<?php

abstract class Merc_DonationManager_Transaction_Abstract
{
	protected $_transactionModel;

	protected $_userModel;

	protected $_processor = '';

	protected $_request;

	protected $_input;

	protected $_transaction = false;

	protected $_errors = array();

	public function __construct(Zend_Controller_Request_Http $request)
	{
		$this->_request = $request;
		$this->_input = new XenForo_Input($request);

		$this->_transactionModel = XenForo_Model::create('Merc_DonationManager_Model_Transaction');
		$this->_userModel = XenForo_Model::create('XenForo_Model_User');
	}

	public function run()
	{
		//if ($this->validateRequest())
		{
			if ($this->validateTransaction())
			{
				return $this->processTransaction();
			}
		}

		return false;
	}

	abstract public function validateRequest();

	abstract public function validateTransaction();

	abstract public function processTransaction();

	public function log($donationId, $transactionId, $type, $message, array $details = array())
	{
		$post = $_POST;
		$post['_callbackIp'] = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false);

		$this->_transactionModel->logTransaction($donationId, $transactionId, $this->_processor, $type, $message, array_merge($details, array('POST' => $post)));

		return $type . ': ' . $message;
	}

	public function error($error)
	{
		$details = $_POST;
		$details['_callbackIp'] = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false);
		$this->log(0, 0, 'error', $error, $details);

		// Log to file so I can easily debug with support requests
		XenForo_Helper_File::log('donation-manager-error', $error);

		$this->_errors[] = $error;

		return false;
	}

	public function hasErrors()
	{
		return !empty($this->_errors);
	}

	public function getErrors()
	{
		return $this->_errors;
	}
}