<?php

class Merc_DonationManager_Transaction_PayPal extends Merc_DonationManager_Transaction_Abstract
{
	protected $_filtered;

	protected $_processor = 'paypal';

	public function __construct(Zend_Controller_Request_Http $request)
	{
		parent::__construct($request);

		$this->_filtered = $this->_input->filter(array(
			'test_ipn' => XenForo_Input::UINT,
			'business' => XenForo_Input::STRING,
			'txn_type' => XenForo_Input::STRING,
			'txn_id' => XenForo_Input::STRING,
			'mc_currency' => XenForo_Input::STRING,
			'mc_gross' => XenForo_Input::NUM,
			'payment_status' => XenForo_Input::STRING,
			'custom' => XenForo_Input::STRING,
		));
	}

	public function validateRequest()
	{
		try
		{
			if ($this->_filtered['test_ipn'] && XenForo_Application::debugMode())
			{
				$validator = XenForo_Helper_Http::getClient('https://www.sandbox.paypal.com/cgi-bin/webscr');
				$testIpn = true;
			}
			else
			{
				$validator = XenForo_Helper_Http::getClient('http://www.paypal.com/cgi-bin/webscr');
				$testIpn = false;
			}
			$validator->setParameterPost('cmd', '_notify-validate');
			$validator->setParameterPost($_POST);
			$validatorResponse = $validator->request('POST');

			if (!$validatorResponse || (($validatorResponse->getBody() != 'VERIFIED' || $validatorResponse->getStatus() != 200) && !$testIpn))
			{
				return $this->error('Request not validated. ' . ($testIpn ? 'TEST - ' : '') . $validatorResponse->getBody() . ': ' . $validatorResponse->getStatus());
			}
		}
		catch (Zend_Http_Client_Exception $e)
		{
			return $this->error('Connection to PayPal failed');
		}

		if (strtolower($this->_filtered['business']) != strtolower(XenForo_Application::get('options')->payPalPrimaryAccount))
		{
			return $this->error('Invalid business account');
		}

		return true;
	}

	public function validateTransaction()
	{
		$options = XenForo_Application::get('options');

		if (!$this->_filtered['txn_id'])
		{
			return $this->error('No txn_id');
		}

		$itemParts = explode(',', $this->_filtered['custom'], 2);
		if (count($itemParts) != 2)
		{
			return $this->error('Invalid item (custom)');
		}

		list($token, $validation) = $itemParts;

		$this->_transaction = $this->_transactionModel->getTransaction($token);
		if (!$this->_transaction)
		{
			return $this->error('No transaction for this token');
		}

		if ($this->_transaction['user_id'])
		{
			$user = $this->_userModel->getFullUserById($this->_transaction['user_id'], array('join' => XenForo_Model_User::FETCH_USER_PERMISSIONS));
			if ($user)
			{
				$tokenParts = explode(',', $validation);
				if (count($tokenParts) != 3 || sha1($tokenParts[1] . $user['csrf_token']) != $tokenParts[2])
				{
					return $this->error('Invalid validation');
				}
			}
		}

		switch ($this->_filtered['txn_type'])
		{
			case 'web_accept':
				$currency = strtolower($options->donationCurrency);

				if ($this->_filtered['mc_gross'] != $this->_transaction['amount'] || strtolower($this->_filtered['mc_currency']) != $currency)
				{
					return $this->error('Invalid payment amount');
				}
		}

		return true;
	}

	public function processTransaction()
	{
		switch ($this->_filtered['txn_type'])
		{
			case 'web_accept':
				if ($this->_filtered['payment_status'] == 'Completed' AND $this->_transaction['transaction_state'] == 'waiting')
				{
					$donationId = $this->_transactionModel->commit($this->_transaction['token']);

					return $this->log($donationId, $this->_transaction['transaction_id'], 'payment', 'Donation Received', $this->_transaction);
				}
				break;
		}

		if ($this->_filtered['payment_status'] == 'Refunded' || $this->_filtered['payment_status'] == 'Reversed')
		{
			if ($this->_transaction['transaction_state'] == 'commited')
			{
				$donationId = $this->_transactionModel->rollback($this->_transaction['token']);

				return $this->log($donationId, $this->_transaction['transaction_id'], 'cancel', 'Donation refunded/reversed', $this->_transaction);
			}
		}

		return $this->log(0, $this->_transaction['transaction_id'], 'info', 'OK, no action', $this->_transaction);
	}
}