<?php

/*
 *
 *
This is hooked in from Listeners/DataWriter.php
class MetaMirror_Listeners_DataWriter
{
    public static function LoadClassDataWriter($class, array &$extend)
    {
        if($class == 'XenForo_DataWriter_DiscussionMessage_Post')
            $extend[] = 'MetaMirror_DataWriter_DiscussionMessage_Post';

Which in turn is hooked up via the ACP Developer Tab, and adding a Code Event Listener to load_class_dataWriter of
MetaMirror_Listeners_DataWriter::LoadClassDataWriter

*
 */

class MetaMirror_DataWriter_DiscussionMessage_Post extends XFCP_MetaMirror_DataWriter_DiscussionMessage_Post
{
	public function save(){
		
		$response = parent::save();


        $options = XenForo_Application::get('options');
        if ($options->MetaMirror_enabled)
        {

            if(!empty($this->_newData['xf_post']['thread_id']) && !empty($this->_newData['xf_post']['post_id']))
            {
              // It's a new thread or post,

                $threadModel = XenForo_Model::create("XenForo_Model_Thread");
                $thread = $threadModel->getThreadById($this->_newData['xf_post']['thread_id']);
                $node_id = $thread['node_id'];

             //   if (in_array($node,self::)

                $post_id = $this->_newData['xf_post']['post_id'];
                if ($options->MetaMirror_instant && !MetaMirror_CronEntry::isExcluded($node_id))
                    MetaMirror_CronEntry::updateSingle($post_id, 'post', 'xf_post','post_id','message');
            }


            if(!empty($this->_existingData['xf_post']['thread_id']) && !empty($this->_existingData['xf_post']['post_id']))
            {

                $threadModel = XenForo_Model::create("XenForo_Model_Thread");
                $thread = $threadModel->getThreadById($this->_existingData['xf_post']['thread_id']);
                $node_id = $thread['node_id'];

                // Editing a post.
                $post_id = $this->_existingData['xf_post']['post_id'];

                if (!MetaMirror_CronEntry::isExcluded($node_id))
                {
                    // So just call the update on that one id.
                    MetaMirror_CronEntry::flushSingle($post_id, 'xf_post','post_id');

                    if ($options->MetaMirror_instant)
                        MetaMirror_CronEntry::updateSingle($post_id, 'post', 'xf_post','post_id','message');
                }
            }
        }



		return $response;
	}
}




































































































































































































































































































































































































































































































































































































































































































































































































































































