<?php

class MinPostLengthEnforcer_DataWriter_DiscussionMessage_Post extends XFCP_MinPostLengthEnforcer_DataWriter_DiscussionMessage_Post
{
	const OPTION_MIN_MESSAGE_LENGTH = 'minMessageLength';
	const OPTION_MIN_MESSAGE_MARKUP = 'minMessageCountMarkup';
	const OPTION_MIN_MESSAGE_OP_CHECK = 'minMessageOpCheck';
	const OPTION_MIN_MESSAGE_OP_LENGTH = 'minMessageOpLength';

	protected function _getDefaultOptions()
	{
		$options = parent::_getDefaultOptions();
		$options[self::OPTION_MIN_MESSAGE_LENGTH] = XenForo_Application::get('options')->messageMinLength;
		$options[self::OPTION_MIN_MESSAGE_MARKUP] = XenForo_Application::get('options')->messageMinCountMarkup;
		$options[self::OPTION_MIN_MESSAGE_OP_CHECK] = XenForo_Application::get('options')->messageMinOpCheck;
		$options[self::OPTION_MIN_MESSAGE_OP_LENGTH] = XenForo_Application::get('options')->messageMinOpLength;

		return $options;
	}

	protected function _checkMessageValidity()
	{
		parent::_checkMessageValidity();
		
		//Check If First Post...
		$discussionDw = $this->getDiscussionDataWriter();
		$isFirstPost = false;
		if ($this->isInsert())
		{
			if (!$discussionDw || $discussionDw->isInsert())
			{
				// likely the first message
				$isFirstPost = true;
			}
			else {
				$isFirstPost = false;
			}
		}

		$opCheck = $this->getOption(self::OPTION_MIN_MESSAGE_OP_CHECK);
		$opLength = $this->getOption(self::OPTION_MIN_MESSAGE_OP_LENGTH);
		$minLength = $this->getOption(self::OPTION_MIN_MESSAGE_LENGTH);
		$countMarkup = $this->getOption(self::OPTION_MIN_MESSAGE_MARKUP);
		
		//If Count BBCode Markup is Enabled...
		if($countMarkup == 1) {
			//Just get the whole message...
			$postMessage = $this->get('message');
		}
		
		//If Not...
		else {
			//Strip out the BBCode...
			$postMessage = XenForo_Helper_String::bbCodeStrip($this->get('message'));
		}
		
		//Count Message Length...
		$countedMessage = utf8_strlen($postMessage);

		//If First Check Enabled and is First Post...
		if($opCheck == 1 && $isFirstPost) {
			$minLength = $opLength;
		}
		
		//If countedMessage < minLength, Throw Error...
		if ($minLength && $countedMessage < $minLength)
			$this->error(new XenForo_Phrase('please_enter_a_message_with_at_least_x_characters', array('count' => $minLength)), 'message');
	}
}