<?php

class ModEss_ControllerPublic_ModEss extends XenForo_ControllerPublic_Abstract
{
	/**
	 * Pre-dispatch, ensure visitor is a moderator.
	 */
	protected function _preDispatch($action)
	{
		$visitor = XenForo_Visitor::getInstance();

		if (!$visitor['is_moderator'])
		{
			throw $this->getNoPermissionResponseException();
		}
	}
	
	/**
	 * Display all logs created since last time log was checked, or custom search
	 * @return XenForo_ViewPublic_Base
	 */
	public function actionModLog()
	{
		$visitor = XenForo_Visitor::getInstance();
		if (!$visitor['is_moderator'] || !$visitor->hasPermission('general', 'canViewModLogCounts'))
		{
			return $this->responseNoPermission();	
		}
		
		$modEssModel = $this->_getModEssModel();
		$logCounts = $modEssModel->getModLogCounts();
		if (!isset($logCounts[$visitor['user_id']]))
			return $this->responseNoPermission();
		
		$sessionLogCounts = $logCounts[$visitor['user_id']];
		if (!$sessionLogCounts['isActive'])
			return $this->responseNoPermission();
		
		$numDays = $desiredActions = $requestedType = $requestedAction = $requestedUser = $fromDate = $totalCount = null;
		$customSearch = false;
		$entries = array();
		$pageEntries = array();
		$pageNavParams = array();	
		$searchParams = array(
			'num_days' => 1,
			'requested_type' => 'all',
			'requested_action' => 'all'
		);
			
		$options = XenForo_Application::get('options');
		$logModel = $this->_getLogModel();
		$perPage = $options->modess_mod_log_per_page;
		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		
		// if Thread Ban is installed then add those actions
		$addOns = XenForo_Application::get('addOns'); // $this->_getDataRegistryModel()->get('addOns');
		if (isset($addOns['ThreadBan']))
			$doIncludeThreadBans = 1;
		else
			$doIncludeThreadBans = 0;
		
		// if Resource Manager is installed then add those actions
		if (isset($addOns['XenResource']) && $visitor->hasPermission('resource', 'view'))
			$doIncludeResources = 1;
		else
			$doIncludeResources = 0;
		
		$doIncludeWarnings = $options->modess_log_warnings['modlog'] && $visitor->hasPermission('general', 'viewWarning') ? 1 : 0;
		
		$specificActions = $modEssModel->getModLogActionsForTemplate($doIncludeThreadBans, $doIncludeResources, $doIncludeWarnings);
		$searchId = $this->_input->filterSingle('sid', XenForo_Input::UINT);
		
		if ($searchId)
		{
			$search = $modEssModel->getModLogSearchById($searchId);
			
			if (!empty($search)	&& $search['user_id'] == $visitor['user_id'])
			{
				$searchParams = json_decode($search['search_params'], true);
				if (!empty($searchParams))
				{
					if (isset($searchParams['desired_actions']))
						$desiredActions = $searchParams['desired_actions'];
					else
						$desiredActions = array();
					
					$numDays = $searchParams['num_days'];
					if ($numDays)
						$customSearch = true;
					
					$requestedType = $searchParams['requested_type'];
					$requestedAction = $searchParams['requested_action'];
					$requestedUser = $searchParams['requested_user'];
					$fromDate = $searchParams['from_date'];
				}
				
				$pageNavParams['sid'] = $search['search_id'];
				$entryIds = json_decode($search['search_results'], true);
				$totalCount = $search['result_count'];
				$numPages = ceil($totalCount / $perPage);
				if ($page > $numPages)
					$page = $numPages;
				
				// grab the ones for the current page
				$from = ($page - 1) * $perPage;
				$pageEntries = array_slice($entryIds, $from, $perPage, true);
				if (!empty($pageEntries))
					$pageEntries = $logModel->getModLogEntriesByIds($pageEntries, false); // false for skipping the weedout check
				
				if ($requestedAction == 'specific')
				{
					foreach ($specificActions AS $key => &$value)
					{
						if (isset($desiredActions[$key]))
						{	
							$value['checked'] = 1;
							$searchParams['desired_actions'][$key] = 1;
						}
					}
				}
			}
		}
		else
		{
			if (!isset($numDays))
				$numDays = $this->_input->filterSingle('num_days', XenForo_Input::UINT);
			if ($numDays)
				$customSearch = true;
			
			$fetchOptions = array();
			$timeNow = XenForo_Application::$time;
			
			if ($customSearch)
			{
				$fetchActions = array();
				$fromDate = $timeNow - ($numDays * 86400);
				
				if (!isset($requestedType))
					$requestedType = $this->_input->filterSingle('requested_type', XenForo_Input::STRING); // all, thread, post, profile_post, threadban
				if (!$requestedType)
					$requestedType = 'all';
				
				if (!isset($requestedAction))
					$requestedAction = $this->_input->filterSingle('requested_action', XenForo_Input::STRING); // all, specific
				if (!$requestedAction)
					$requestedAction = 'all';
				
				if ($requestedAction == 'specific')
				{
					if (!isset($desiredActions))
						$desiredActions = $this->_input->filterSingle('desired_actions', XenForo_Input::ARRAY_SIMPLE);
					
					if (empty($desiredActions)) // if none were un-checked then skip and fetch all
					{
						$requestedAction = 'all';
					}
					else
					{
						$typeActions = $modEssModel->getModLogActionsForTemplate($doIncludeThreadBans, $doIncludeResources, $doIncludeWarnings, $requestedType);
						
						if (count($typeActions) != count($desiredActions)) // if all were checked then skip specific actions and fetch all
						{
							foreach ($typeActions AS $key => $value)
							{
								if (isset($desiredActions[$key]))
								{
									if ($value['type'] == 'all')
									{
										if (empty($requestedType) || $requestedType == 'all')
										{
											$fetchActions['post'][] = $key;
											$fetchActions['profile_post'][] = $key;
											$fetchActions['thread'][] = $key;
											$fetchActions['resource'][] = $key;
											$fetchActions['resource_update'][] = $key;
											$fetchActions['modess'][] = $key;
										}
										else if ($requestedType == 'resource')
										{
											$fetchActions['resource'][] = $key;
											$fetchActions['resource_update'][] = $key;
										}
										else
										{
											$fetchActions[$requestedType][] = $key;
										}
									}
									else if ($value['type'] == 'post_thread')
									{
										if (empty($requestedType) || $requestedType == 'all')
										{
											$fetchActions['post'][] = $key;
											$fetchActions['thread'][] = $key;
										}
										else
										{
											$fetchActions[$requestedType][] = $key;
										}
									}
									else if ($value['type'] == 'threadban')
									{
										if ($doIncludeThreadBans)
											$fetchActions['thread'][] = $key;
										else
											continue;
									}
									else if ($value['type'] == 'resource')
									{
										if ($doIncludeResources)
										{
											if ($key == 'resource_edit' || $key == 'resource_update_edit')
											{
												$realKey = 'edit';
											}
											else if ($key == 'resource_reassign')
											{
												$realKey = 'reassign';
											}
											else if ($key == 'resource_feature')
											{
												$realKey = 'feature';
											}
											else if ($key == 'resource_unfeature')
											{
												$realKey = 'unfeature';
											}
											else
											{
												$realKey = $key;
											}
											
											$fetchActions['resource'][] = $realKey;
										}
										else
											continue;
									}
									else if ($value['type'] == 'modess')
									{
										if ($key == 'warn' && $doIncludeWarnings)
										{
											// we count all actions under 'warn'
											$fetchActions['modess'][] = 'warn';
											$fetchActions['modess'][] = 'warn_update';
											$fetchActions['modess'][] = 'warn_delete';
										}
										else
											continue;
									}
									else
									{
										$fetchActions[$value['type']][] = $key;
									}
									
									$specificActions[$key]['checked'] = 1;
									$searchParams['desired_actions'][$key] = 1;
								}
							}
						}
					}
				}
				
				$skipActions = array();
				
				if ($requestedType != 'all')
				{
					if ($requestedType == 'threadban')
						$fetchOptions['content_type'] = 'thread';
					else
						$fetchOptions['content_type'] = $requestedType;
					
					if ($doIncludeThreadBans)
					{
						if (!isset($fetchActions['thread']))
						{
							if ($requestedType == 'threadban')
							{
								// if no specific action selected, add all threadban actions
								// since threadban uses the thread type we must include those explicitly
								$fetchActions['thread'][] = 'threadban';
								$fetchActions['thread'][] = 'threadban_edit';
								$fetchActions['thread'][] = 'threadbanlift_cron';
								$fetchActions['thread'][] = 'threadbanlift';
							}
							else if ($requestedType == 'thread')
							{
								// since threadban uses the thread type we must exclude those from a thread type search
								$skipActions['include']['thread'][] = 'threadban';
								$skipActions['include']['thread'][] = 'threadban_edit';
								$skipActions['include']['thread'][] = 'threadbanlift_cron';
								$skipActions['include']['thread'][] = 'threadbanlift';
							}
						}
					}
				}
				
				if ($requestedType == 'thread' || $requestedType == 'all')
				{
					// if AVForums_ModCheckpoint is installed then do not fetch the 'posts_checked' entries as they are not needed
					if (isset($addOns['AVForums_ModCheckpoint']))
					{
						$skipActions['include']['thread'][] = 'posts_checked';
						$skipActions['include']['thread'][] = 'bulk_posts_checked';
					}
				}
				
				if (!$doIncludeResources)
				{
					unset($fetchActions['resource'], $fetchActions['resource_update']);
				}
				
				if (!$doIncludeWarnings)
				{
					unset($fetchActions['modess']);
					/*
					// currently the 'modess' type only includes warning stuff but if other actions are added then use the following
					if (isset($fetchActions['modess']))
					{
						foreach ($fetchActions['modess'] AS $key => $value)
						{
							if ($value == 'warn' || $value == 'warn_update' || $value == 'warn_delete')
								unset($fetchActions['modess'][$key]);
						}
						
						if (empty($fetchActions['modess']))
							unset($fetchActions['modess']);
					}
					*/
					
					// this user cannot view warnings but they are still saved in the log
					// therefore we must skip the action as default is to fetch all log types
					if (empty($fetchActions) && $options->modess_log_warnings['dolog'])
					{
						$skipActions['exclude']['modess'] = array();
						//$skipActions['exclude']['modess'][] = 'warn';
						//$skipActions['exclude']['modess'][] = 'warn_update';
						//$skipActions['exclude']['modess'][] = 'warn_delete';
					}
				}
				
				if (!isset($requestedUser))
				{
					$requestedUser = $this->_input->filterSingle('requested_user', XenForo_Input::STRING); // all, exclude self, mod name
				}
				
				if (!empty($requestedUser) && $requestedUser != 'all')
				{
					if ($requestedUser == 'all_but_self')
						$fetchOptions['exclude_user_ids'] = array($visitor['user_id']);
					else
						$fetchOptions['include_user_ids'] = array(intval($requestedUser));
				}
				
				if (!empty($fetchActions))
				{
					$fetchOptions['actions'] = $fetchActions;
				}
				
				if (!empty($skipActions))
				{
					$fetchOptions['skip_actions'] = $skipActions;
				}
				
				// get only logs from forums where the user has permission to view the thread log
				$entries = $logModel->getViewableModLogEntries($fromDate, $fetchOptions);
			}
			else // not custom search
			{
				$sessionLogDisabled = false; // whether to skip fetching entries since last check and thus only have custom searches
				$fromDate = $sessionLogCounts['lastViewDate']; // fetch all since last log view
				$preferences = $modEssModel->getModEssPreferencesByUserId($visitor['user_id']);
				if (!empty($preferences))
				{
					$desiredType = $preferences['action_type'];
					if ($desiredType == 'none')
					{
						$sessionLogDisabled = true; // user does not want to be notified of new entries
					}
				}
				
				// get only logs from forums where the user has permission to view the thread log
				if (!$sessionLogDisabled)
				{
					$entryIds = $sessionLogCounts['logIds'];
					if ($entryIds)
					{
						$entryIds = explode(',', $entryIds);
						$entries = $logModel->getModLogEntriesByIds($entryIds);
					}
				}
			}
			
			if (!empty($entries))
			{
				$totalCount = count($entries); // count after unviewables were weeded out
				$numPages = ceil($totalCount / $perPage);
				if ($page > $numPages)
					$page = $numPages;
				
				// grab the ones for the current page
				$from = ($page - 1) * $perPage;
				$pageEntries = array_slice($entries, $from, $perPage, true);
				
				// if multiple pages then save results
				if (($totalCount / $perPage) > 1)
				{
					$searchParams['num_days'] = $numDays;
					$searchParams['from_date'] = $fromDate;
					$searchParams['requested_type'] = $requestedType;
					$searchParams['requested_action'] = $requestedAction;
					$searchParams['requested_user'] = $requestedUser;
					$searchParams['from_date'] = $fromDate;
															//(array $resultIds, array $params, $userId = null, $searchDate = null)
					$search = $modEssModel->insertModLogSearch(array_keys($entries), $searchParams);
					$pageNavParams['sid'] = $search['search_id'];
				}
			}
			else
			{
				$totalCount = 0;
				$page = 1;
			}
			
			if (!$customSearch)
			{	
				// update session count
				$sessionLogCounts = array('total' => 0, 'lastViewDate' => $timeNow, 'logIds' => '', 'isActive' => true);
				XenForo_Application::get('session')->set('modLogCounts', $sessionLogCounts);
				
				// update registry count
				$logCounts[$visitor['user_id']] = $sessionLogCounts;
				$this->_getDataRegistryModel()->set('modLogCounts', $logCounts);
			}
		}
		
		// process the logs
		if (!empty($pageEntries))
		{
			$pageEntries = $logModel->addLinksToModLogEntries($pageEntries); // add content links
			$pageEntries = $logModel->prepareModeratorLogEntries($pageEntries); // prepare logs
		}
		
		// limit entries to the last X days
		$maxDays = $options->modess_mod_log_search_max_days;
		if ($maxDays < 1)
			$maxDays = 1;
		
		// an array of max available days for the template's num_days
		$maxDaysArray = array();
		$i = 1;
		while ($i <= $maxDays)
		{
			$maxDaysArray[$i] = $i;
			$i++;
		}
		
		$viewParams = array(
			'logEntries' => $pageEntries,
			'totalCount' => $totalCount,
			'lastViewDate' => $fromDate,
			'page' => $page,
			'perPage' => $perPage,
			'canViewIp' => ($options->modess_mod_log_show_ips && $visitor->hasPermission('general', 'viewIps')),
			'customSearch' => $customSearch,
			'maxDays' => $maxDays,
			'maxDaysArray' => $maxDaysArray,
			'specificActions' => $specificActions,
			'doIncludeThreadBans' => $doIncludeThreadBans,
			'doIncludeResources' => $doIncludeResources,
			'doIncludeWarnings' => $doIncludeWarnings,
			'mods' => $modEssModel->getSessionModLogModerators()
		);
		
		if ($customSearch)
		{
			$viewParams['requestedType'] = $requestedType;
			$viewParams['requestedAction'] = $requestedAction;
			$viewParams['requestedUser'] = $requestedUser;
			$viewParams['numDays'] = $numDays;
		}
		
		if (empty($pageEntries))
		{
			$viewParams['linkPreferences'] = XenForo_Link::buildPublicLink('account/preferences');
			$viewParams['linkLast24Hours'] = XenForo_Link::buildPublicLink('modess/modLog', '', array('num_days' => 1));
		}
		
		$viewParams['pageNavParams'] = $pageNavParams;
		return $this->responseView('XenForo_ViewPublic_Base', 'modess_session_mod_log', $viewParams);
	}
	
	/**
	 * Session activity details.
	 * @see XenForo_Controller::getSessionActivityDetailsForList()
	 */
	public static function getSessionActivityDetailsForList(array $activities)
	{
		return new XenForo_Phrase('performing_moderation_duties');
	}
	
	/**
	 * @return XenForo_Model_DataRegistry
	 */
	protected function _getDataRegistryModel()
	{
		return $this->getModelFromCache('XenForo_Model_DataRegistry');
	}
	
	/**
	 * @return XenForo_Model_Log
	 */
	protected function _getLogModel()
	{
		return $this->getModelFromCache('XenForo_Model_Log');
	}
	
	/**
	 * @return ModEss_Model_ModEss
	 */
	protected function _getModEssModel()
	{
		return $this->getModelFromCache('ModEss_Model_ModEss');
	}
	
	/**
	 * @return XenForo_Model_AddOn
	 */
	protected function _getAddOnModel()
	{
		return $this->getModelFromCache('XenForo_Model_AddOn');
	}
}