<?php

/**
 * Controller for handling actions on threads.
 *
 * @package ModEss
 */
class ModEss_ControllerPublic_Thread extends XFCP_ModEss_ControllerPublic_Thread
{
	/**
	 * Displays a thread.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionIndex()
	{
		$response = parent::actionIndex();
		
		if (!empty($response->params) && isset($response->params['thread']))
		{
			$thread = $response->params['thread'];
			if (isset($thread['node_id'])) // some people seem to have a conflict with another add-on which returns a thread with no node_id
			{
				$visitor = XenForo_Visitor::getInstance();
				
				// show deleted posts link in thread tools
				$response->params['canViewDeletedPosts'] = $visitor->hasNodePermission($thread['node_id'], 'viewDeleted');
			}
		}
		
		return $response;
	}
	
	/**
	 * Updates an existing thread.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionSave()
	{
		if (!XenForo_Application::get('options')->modess_sticky_thread_order)
		{
			return parent::actionSave();
		}
		
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		if (!$this->_getThreadModel()->canStickUnstickThread($thread, $forum))
		{
			return parent::actionSave();
		}
		
		$response = parent::actionSave();
		$doStickyOrder = false;
		
		if ($this->_input->filterSingle('_returnDiscussionListItem', XenForo_Input::UINT))
		{
			// ensures we passed the assertThreadValidAndViewable check inside the _returnDiscussionListItem section
			if (!empty($response->params) && isset($response->params['thread']))
			{
				$thread = $response->params['thread'];
				$threadId = $thread['thread_id'];
				$doStickyOrder = true;
			}
		}
		else
		{
			$doStickyOrder = true;
		}
		
		if ($doStickyOrder)
		{
			$sticky = $this->_input->filterSingle('sticky', XenForo_Input::UINT);
			$stickyOrder = $this->_input->filterSingle('sticky_order', XenForo_Input::UINT);
			$stickyOrderModel = $this->_getSTOModel();
			
			if ($sticky && $stickyOrder)
			{
				$stickyOrderModel->addOrEditStickyOrder($stickyOrder, $threadId);
			}
			else
			{
				$stickyOrderModel->deleteStickyOrder($threadId);
			}
		}
		
		return $response;
	}
		
	/**
	 * @return ModEss_Model_STO
	 */
	protected function _getSTOModel()
	{
		return $this->getModelFromCache('ModEss_Model_STO');
	}
	
	/**
	 * @return XenForo_Model_Node
	 */
	protected function _getNodeModel()
	{
		return $this->getModelFromCache('XenForo_Model_Node');
	}
	
	/**
	 * @return XenForo_Model_Log
	 */
	protected function _getLogModel()
	{
		return $this->getModelFromCache('XenForo_Model_Log');
	}
}