<?php

/**
* Data writer for convess_privacy.
*
* @package ModEss
*/
class ModEss_DataWriter_Preferences extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'modess_modlog_preferences'	=> array(
				'user_id'   				=> array('type' => self::TYPE_UINT, 'required' => true),
				'action_type'				=> array('type' => self::TYPE_STRING, 'required' => true),
				'action_names' 				=> array('type' => self::TYPE_JSON, 'required' => true)
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$userId = $this->_getExistingPrimaryKey($data, 'user_id'))
		{
			return false;
		}

		return array('modess_modlog_preferences' => $this->_getModEssdModel()->getModEssPreferencesByUserId($userId));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'user_id = ' . $this->_db->quote($this->getExisting('user_id'));
	}

	/**
	 * @return ModEss_Model_ModEss
	 */
	protected function _getModEssdModel()
	{
		return $this->getModelFromCache('ModEss_Model_ModEss');
	}
}