<?php

/**
* Data writer for warnings.
*
* @package ModEss
*/
class ModEss_DataWriter_Warning extends XFCP_ModEss_DataWriter_Warning
{
	/**
	 * Post-delete handling.
	 */
	protected function _postSave()
	{
		parent::_postSave();
		
		if (XenForo_Application::get('options')->modess_log_warnings['dolog'])
		{
			$content = array();
			$contentType = $this->get('content_type');
			
			if ($this->isInsert())
			{
				$content = $this->getExtraData(self::DATA_CONTENT);
				if (!$content)
				{
					$warningHandler = $this->_getWarningModel()->getWarningHandler($contentType);
					if ($warningHandler)
					{
						$content = $warningHandler->getContent($this->get('content_id'));
					}
				}
			}
			else if ($this->isUpdate() && $this->isChanged('expiry_date'))
			{				
				$warningHandler = $this->_getWarningModel()->getWarningHandler($contentType);
				if ($warningHandler)
				{
					$content = $warningHandler->getContent($this->get('content_id'));
				}			
			}
			
			if (!empty($content))
			{
				$user = $this->getModelFromCache('XenForo_Model_User')->getUserById($this->get('user_id'));
				
				if (!empty($user))
				{
					$warning = $this->getMergedData();
					$warning['username'] = $user['username'];
					$action = 'warn';
					
					if ($this->isUpdate())
					{
						// on updates a phrase is used for the title but we want the actual title
						if ($contentType == 'post')
						{
							$warning['content_title'] = $content['title'];
						}
						else if ($contentType == 'profile_post')
						{
							$warning['content_title'] = $content['profile_username'];
						}
						
						$warning['previous_expiry_date'] = $this->getExisting('expiry_date');
						$action = 'warn_update';
					}
					
					// LOG MODERATOR ACTION
					XenForo_Model_Log::logModeratorAction(
						'modess', $warning,
						$action, $content
					);
				}
			}
		}
	}
	
	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
		parent::_postDelete();
		
		$contentType = $this->get('content_type');
		$warningHandler = $this->_getWarningModel()->getWarningHandler($contentType);
		
		if ($warningHandler)
		{
			$content = $warningHandler->getContent($this->get('content_id'));
		}
		
		if (!empty($content))
		{
			$user = $this->getModelFromCache('XenForo_Model_User')->getUserById($this->get('user_id'));
			
			if (!empty($user))
			{
				$warning = $this->getMergedData();
				$warning['username'] = $user['username'];
				
				// on updates a phrase is used for the title but we want the actual title
				if ($contentType == 'post')
				{
					$warning['content_title'] = $content['title'];
				}
				else if ($contentType == 'profile_post')
				{
					$warning['content_title'] = $content['profile_username'];
				}
				
				// LOG MODERATOR ACTION
				XenForo_Model_Log::logModeratorAction(
					'modess', $warning,
					'warn_delete', $content
				);
			}		
		}
	}
}