<?php

class ModEss_Install_Construct
{
	public static function install($existingAddOn, $addOnData)
	{
		if (XenForo_Application::$versionId < 1030032)
		{
			throw new XenForo_Exception('This Add-On requires XenForo version 1.3.0 or newer.');
		}
		
		$db = XenForo_Application::get('db');
		
		if ($existingAddOn) // upgrade
		{
			$versionId = $existingAddOn['version_id'];
			
			if ($versionId < 105)
			{
				// sticky thread order
				$db->query("
					CREATE TABLE IF NOT EXISTS sticky_thread_order (
						thread_id INT UNSIGNED NOT NULL,
						display_order INT UNSIGNED NOT NULL DEFAULT 0,
						PRIMARY KEY thread_id_display_order (thread_id, display_order)
					) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
				");
			}
			
			if ($versionId < 111)
			{
				$db->query("
					DELETE FROM xf_permission_entry
					WHERE permission_id = 'canViewThreadLog'
				");
				
				$db->query("
					DELETE FROM xf_permission_entry_content
					WHERE permission_id = 'canViewThreadLog'
				");
				
				$db->query("
					UPDATE xf_moderator_log
					SET action = 'post_move_target_existing'
					WHERE content_type = 'thread' AND action = 'modess_post_move_target'
				");
			}
			
			if ($versionId < 112)
			{
				// CONTENT TYPES
				$db->query("
					INSERT IGNORE INTO xf_content_type (content_type, addon_id)
					VALUES ('modess', 'ModEss')
				");
				
				// CONTENT TYPE	FIELDS	
				$db->query("
					INSERT IGNORE INTO xf_content_type_field (content_type, field_name, field_value)
					VALUES
					('modess', 'moderator_log_handler_class', 'ModEss_ModeratorLogHandler_Warning')
				");
				
				XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();			
			}
		}
		else // fresh install
		{
			// mod log alert preferences
			$db->query("
				CREATE TABLE IF NOT EXISTS modess_modlog_preferences (
					user_id INT UNSIGNED NOT NULL PRIMARY KEY,
					action_type VARCHAR(25) NOT NULL,
					action_names BLOB NOT NULL
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// mod log search results
			$db->query("
				CREATE TABLE IF NOT EXISTS modess_modlog_search (
					search_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
					search_results MEDIUMBLOB NOT NULL,
					result_count SMALLINT UNSIGNED NOT NULL,
					user_id INT UNSIGNED NOT NULL,
					search_date INT UNSIGNED NOT NULL,
					search_params BLOB NOT NULL,
					PRIMARY KEY (search_id)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// sticky thread order
			$db->query("
				CREATE TABLE IF NOT EXISTS sticky_thread_order (
					thread_id INT UNSIGNED NOT NULL,
					display_order INT UNSIGNED NOT NULL DEFAULT 0,
					PRIMARY KEY thread_id_display_order (thread_id, display_order)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// CONTENT TYPES
			$db->query("
				INSERT IGNORE INTO xf_content_type (content_type, addon_id)
				VALUES ('modess', 'ModEss')
			");
			
			// CONTENT TYPE	FIELDS	
			$db->query("
				INSERT IGNORE INTO xf_content_type_field (content_type, field_name, field_value)
				VALUES
				('modess', 'moderator_log_handler_class', 'ModEss_ModeratorLogHandler_Warning')
			");
			
			XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
		}
	}

	public static function uninstall()
	{
		$db = XenForo_Application::get('db');
		
		$dataRegistryModel = XenForo_Model::create('XenForo_Model_DataRegistry');
		$dataRegistryModel->delete('modLogCounts');
		
		$db->query("
			DROP TABLE IF EXISTS modess_modlog_preferences
		");
		
		$db->query("
			DROP TABLE IF EXISTS modess_modlog_search
		");
		
		$db->query("
			DROP TABLE IF EXISTS sticky_thread_order
		");
		
		$db->query("
			DELETE FROM xf_permission_entry
			WHERE permission_id IN ('canViewModLogCounts', 'viewPostPlaceholders', 'viewThreadPlaceholders')
		");
		
		$db->query("
			DELETE FROM xf_permission_entry_content
			WHERE permission_id IN ('canViewModLogCounts', 'viewPostPlaceholders', 'viewThreadPlaceholders')
		");
		
		$db->query("
			DELETE FROM xf_moderator_log
			WHERE content_type = 'modess'
		");
		
		$db->query("
			DELETE FROM xf_content_type_field
			WHERE content_type = 'modess'
		");
		
		$db->query("
			DELETE FROM xf_content_type
			WHERE addon_id = 'ModEss'
		");
		
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
	}
}