<?php

/**
 * Model for posts.
 *
 * @package ModEss
 */
class ModEss_Model_Post extends XFCP_ModEss_Model_Post
{
	/**
	 * Prepares a post for display, generally within the context of a thread.
	 *
	 * @param array $post Post to prepare
	 * @param array $thread Thread post is in
	 * @param array $forum Forum thread/post is in
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return array Prepared version of post
	 */
	public function preparePost(array $post, array $thread, array $forum, array $nodePermissions = null, array $viewingUser = null)
	{
		$post = parent::preparePost($post, $thread, $forum, $nodePermissions, $viewingUser);
		
		// whether or not to display the show post link
		$viewDeleted = $this->_getModEssModel()->viewDeleted($thread['node_id'], $nodePermissions, $viewingUser);
		$post['canViewDeleted'] = $viewDeleted;
		$post['canViewReason'] = ($viewDeleted ? true : XenForo_Application::get('options')->modess_delete_placeholder_view_reason);
		
		return $post;
	}
	
	/**
	 * Gets permission-based options that apply to post fetching functions.
	 *
	 * @param array $thread Thread the posts will belong to
	 * @param array $forum Forum the thread belongs to
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return array Keys: deleted/moderated (both booleans)
	 */
	public function getPermissionBasedPostFetchOptions(array $thread, array $forum, array $nodePermissions = null, array $viewingUser = null)
	{
		$conditions = parent::getPermissionBasedPostFetchOptions($thread, $forum, $nodePermissions, $viewingUser);
		
		if (!$conditions['deleted'] && $this->_getModEssModel()->viewDeletedPostPlaceholders($thread['node_id'], $nodePermissions, $viewingUser))
		{
			$conditions['deleted'] = true;
		}
		
		return $conditions;
	}
	
	/**
	 * @return ModEss_Model_ModEss
	 */
	protected function _getModEssModel()
	{
		return $this->getModelFromCache('ModEss_Model_ModEss');
	}
}