<?php

class ModEss_ModeratorLogHandler_Warning extends XenForo_ModeratorLogHandler_Abstract
{
	protected function _log(array $logUser, array $content, $action, array $params = array(), $parentContent = null)
	{
		$actionParams = array(
			'warning_id' =>  $content['warning_id'],
			'title' =>  $content['title'],
			'notes' =>  $content['notes'],
			'points' =>  $content['points'],
			'expiry_date' =>  $content['expiry_date'],
			'username' => isset($params['username']) ? $params['username'] : '',
			'user_url' => XenForo_Link::buildPublicLink('members', array('user_id' => $content['user_id'], 'username' => $content['username'])) . '#warnings'
		);
		
		if (isset($content['previous_expiry_date']))
			$actionParams['previous_expiry_date'] = $content['previous_expiry_date'];
		
		$contentUrl = '';
		if ($content['content_type'] == 'user')
		{
			$contentUrl = XenForo_Link::buildPublicLink('members', array('user_id' => $content['content_id'], 'username' => $content['username']));
		}
		else if ($content['content_type'] == 'post')
		{
			$contentUrl = XenForo_Link::buildPublicLink('posts', array('post_id' => $content['content_id']));
			
			if (!empty($params))
			{
				$actionParams['content_id'] = $params['thread_id'];
				$actionParams['node_id'] = $params['node_id'];
				$actionParams['node_title'] = $params['node_title'];
				$actionParams['post_id'] = $params['post_id'];
			}
		}
		else if ($content['content_type'] == 'profile_post')
		{
			$contentUrl = XenForo_Link::buildPublicLink('profile-posts', array('profile_post_id' => $content['content_id']));
		}
		else if ($content['content_type'] == 'resource_update')
		{
			$contentUrl = XenForo_Link::buildPublicLink('resources/update', '', array('resource_update_id' => $content['content_id']));
			if (!empty($params))
			{
				// so we know if its an actual update or just the main resource page
				if ($params['description_update_id'] != $params['resource_update_id'])
					$actionParams['is_actual_update'] = true;
				else 
					$actionParams['is_actual_update'] = false;
				
				$actionParams['resource_id'] = $params['resource_id'];
				$actionParams['resource_title'] = $params['resource_title'];
				$actionParams['category_id'] = $params['resource_category_id'];
				$actionParams['category_title'] = $params['category_title'];
			}
		}
		
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_ModeratorLog');
		$dw->bulkSet(array(
			'user_id' => $logUser['user_id'],
			'content_type' => 'modess',
			'content_id' => $content['content_id'],
			'content_user_id' => $content['user_id'],
			'content_username' => $content['username'],
			'content_title' => $content['content_title'],
			'content_url' => $contentUrl,
			'discussion_content_type' => $content['content_type'],
			'discussion_content_id' => (isset($actionParams['content_id']) ? $actionParams['content_id'] : $content['content_id']),
			'action' => $action,
			'action_params' => $actionParams
		));
		$dw->save();

		return $dw->get('moderator_log_id');
	}
	
	protected function _prepareEntry(array $entry)
	{
		$warning = json_decode($entry['action_params'], true);
		if (!empty($warning))
		{
			if ($warning['expiry_date'] > 0 && $warning['expiry_date'] < XenForo_Application::$time)
			{
				$warning['is_expired'] = true;
			}
			
			$entry['warning'] = $warning;
		}
		
		return $entry;
	}
}