<?php

class Nobita_LastPostPrefix_DataWriter_Forum extends XFCP_Nobita_LastPostPrefix_DataWriter_Forum
{
	protected function _getFields() {
		$fields = parent::_getFields();
		
		$fields['xf_forum']['last_post_prefix_caches'] = array('type' => self::TYPE_SERIALIZED, 'default' => '');
		return $fields;
	}
	
	public function updateCountersAfterDiscussionSave(XenForo_DataWriter_Discussion $discussionDw, $forceInsert = false) {
		$response = parent::updateCountersAfterDiscussionSave($discussionDw, $forceInsert);
		
		if ($discussionDw->get('discussion_state') == 'visible' && $discussionDw->get('last_post_date') >= $this->get('last_post_date')) {
			$this->updateLastPost();
		}
		
		return $response;
	}
	
	public function updateLastPost() {
		$response = parent::updateLastPost();
		
		$lastPost = $this->getModelFromCache('XenForo_Model_Thread')->getLastUpdatedThreadInForum($this->get('node_id'));
		if($lastPost) {
			$this->set('last_post_prefix_caches', $lastPost);
		}
		
		return $response;
	}
}