<?php

class Nobita_LastPostPrefix_NodeHandler_Forum extends XFCP_Nobita_LastPostPrefix_NodeHandler_Forum
{
	protected function _getForumLikePushableData(array $node, array $childPushable) {
		$result = parent::_getForumLikePushableData($node, $childPushable);
		
		if(@unserialize($node['last_post_prefix_caches']) !== false) {
			$result['last_post_prefix_caches'] = $node['last_post_prefix_caches'];
			
			$lastPostData = @unserialize($node['last_post_prefix_caches']);
			
			if($lastPostData['last_post_id'] == $result['lastPost']['post_id']) { // prevent diplay wrong prefix...
				$result['lastPostPrefix'] = @unserialize($node['last_post_prefix_caches']);
			}
			
		}
		
		return $result;
	}
	
	protected function _compileForumLikePushableData(array $newPushable, array $childPushable) {
		$result = parent::_compileForumLikePushableData($newPushable, $childPushable);
		
		foreach($childPushable as $childData) {
			$lastPostData = @unserialize($childData['last_post_prefix_caches']);
			
			if(is_array($lastPostData)) {
				$result['lastPostPrefix'] = $lastPostData;
			}
		}
		
		return $result;
	}
}