<?php
class Nobita_MetaDescription_Installer
{
	public static function getData()
	{
		$data = array();

		$data["xf_thread"] = array(
			'createQuery' => 'ALTER TABLE `xf_thread` ADD COLUMN `meta_description` VARCHAR(255) NOT NULL DEFAULT \'\'',
			'dropQuery' => 'ALTER TABLE `xf_thread` DROP COLUMN `meta_description`'
		);

		$data["xf_forum"] = array(
			'createQuery' => 'ALTER TABLE `xf_forum` ADD COLUMN `forum_meta_description` VARCHAR(255) NOT NULL DEFAULT \'\'',
			'dropQuery' => 'ALTER TABLE `xf_forum` DROP COLUMN `forum_meta_description`'
		);

		return $data;
	}

	public static function install()
	{
		$db = XenForo_Application::getDb();
		
		foreach (self::getData() as $tableName => $alter)
		{
			try
			{
				$db->query($alter['createQuery']);
			}
			catch (Zend_Db_Exception $e) {}
		}
	}

	public static function uninstall()
	{
		$db = XenForo_Application::getDb();
		
		foreach (self::getData() as $tableName => $alter)
		{
			try
			{
				$db->query($alter['dropQuery']);
			}
			catch (Zend_Db_Exception $e) {}
		}
	}
}