<?php
class Nobita_MetaDescription_Listener
{
	public static function loadControllers($class, array &$extend)
	{
		static $controllers = array(
			'XenForo_Model_Thread',

			'XenForo_ControllerPublic_Thread',
			'XenForo_ControllerAdmin_Forum',
			
			'XenForo_DataWriter_Forum'
		);

		if (in_array($class, $controllers))
		{
			$extend[] = 'Nobita_MetaDescription_' . $class;
		}
	}

	protected static $_hasNoFollow = false;
	public static function template_hook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		if ($hookName == 'thread_view_tools_links')
		{
			$contents .= $template->create('meta_thread_view_tools_links', $template->getParams())->render();
		}
		else if ($hookName == 'footer_after_copyright')
		{
			$domain = XenForo_Application::getOptions()->boardUrl;
			if (strpos($domain, "http://") === false)
			{
				$domain = 'http://' . $domain;
			}

			$params = $template->getParams();
			if (!in_array(md5(sha1($domain)), array('a02f826f6575db3bd7ad741cea6cfd58'))
				&& isset($params['contentTemplate'])
				&& $params['contentTemplate'] == 'forum_list'
			)
			{
				$styleCss = 'clear: both; text-align: left;';
			}
		}
	}

	public static function template_post_render($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		if ($templateName == 'thread_view')
		{
			$params = $template->getParams();

			if (!empty($containerData['head']) && !empty($params['thread']))
			{
				if (strlen(trim($params['thread']['meta_description'])) != 0)
				{
					$containerData['head']['description'] = '
	<meta name="description" content="' . $params['thread']['meta_description'] . '" />';
	
					$pattern = '/<meta(?=[^>]*property="og:description")\s[^>]*content="([^>]*)"/si';
					preg_match($pattern, $containerData['head']['openGraph'], $matched);

					if (!empty($matched))
					{
						$replace = '<meta property="og:description" content="' . $params['thread']['meta_description'] . '"';
						$containerData['head']['openGraph'] = str_replace($matched[0], $replace, $containerData['head']['openGraph']);
					}
				}
			}
		}
		else if ($templateName == 'forum_view')
		{
			$params = $template->getParams();
			
			if (!empty($containerData['head']) && !empty($params['forum']))
			{
				if (strlen(trim($params['forum']['forum_meta_description'])) != 0)
				{
					$containerData['title'] = $params['forum']['forum_meta_description'];
				}
			}
		}
		else if ($templateName == 'forum_edit')
		{
			$params = $template->getParams();
			
			$search = '<!-- slot: after_description -->';
			$pos = strpos($content, $search);
			
			if ($pos !== false)
			{
				$insertTemplate = $template->create('meta_description_forum_edit', $params)->render();
				$content = substr_replace($content, $insertTemplate, $pos, 0);
			}
		}
	}

}