<?php
class Nobita_MetaDescription_XenForo_ControllerPublic_Thread extends XFCP_Nobita_MetaDescription_XenForo_ControllerPublic_Thread
{
	public function actionMetaTag()
	{
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);

		$threadModel = $this->_getThreadModel();

		if (!$threadModel->metaDes_canChangeMetaTag($thread, $forum, $key))
		{
			throw $this->getErrorOrNoPermissionResponseException($key);
		}

		if ($this->isConfirmedPost())
		{
			$meta = $this->_input->filterSingle('meta_description', XenForo_Input::STRING);

			if (strlen($meta) > 255)
			{
				return $this->responseError(new XenForo_Phrase('please_enter_message_with_no_more_than_x_characters', array(
					'count' => 255
				)));
			}

			$this->_getThreadModel()->updateMetaDescriptionForThread($thread['thread_id'], $meta);

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('threads', $thread)
			);
		}
		else
		{
			$viewParams = array(
				'thread' => $thread,
				'forum' => $forum,
				'nodeBreadCrumbs' => $ftpHelper->getNodeBreadCrumbs($forum)
			);

			return $this->responseView('Nobita_MetaDescription_ViewPublic_Thread_MetaDes', 'thread_meta_description', $viewParams);
		}
	}
}