<?php
class Nobita_MetaDescription_XenForo_Model_Thread extends XFCP_Nobita_MetaDescription_XenForo_Model_Thread
{
	public function metaDes_canChangeMetaTag(array $thread, array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		$this->standardizeViewingUserReferenceForNode($thread['node_id'], $viewingUser, $nodePermissions);

		return ($viewingUser['user_id']
			&& XenForo_Permission::hasContentPermission($nodePermissions, 'updateMetaDes')
		);
	}

	public function updateMetaDescriptionForThread($threadId, $meta = '')
	{
		$db = $this->_getDb();
		
		$db->update('xf_thread', array(
			'meta_description' => $meta
		),  'thread_id = ' . $db->quote($threadId));
	}

	public function prepareThread(array $thread, array $forum, array $nodePermissions = null, array $viewingUser = null)
	{
		$thread['updateMetaDescription'] = $this->metaDes_canChangeMetaTag($thread, $forum, $errorPhraseKey, $nodePermissions, $viewingUser);

		return parent::prepareThread($thread, $forum, $nodePermissions, $viewingUser);
	}

}