<?php
class Nobita_PasswordRules_Listener {
	const XENFORO_CONTROLLERPUBLIC_ACTIONSECURITYSAVE = 'Nobita_PasswordRules_XenForo_ControllerPublic_Account::actionSecuritySave';
	const XENFORO_CONTROLLERPUBLIC_ACTIONREGISTER = 'Nobita_PasswordRules_XenForo_ControllerPublic_Register::actionRegister';

	const ERROR_CONTROLLER_CLASS = 'XenForo_ControllerPublic_Error';
	public static function loadControllers($class, array &$extend) {
		static $controllers = array(
			'XenForo_DataWriter_User',
			
			'XenForo_ControllerPublic_Account',
			'XenForo_ControllerPublic_Register'
		);

		if (in_array($class, $controllers)) $extend[] = 'Nobita_PasswordRules_'.$class;
	}

	protected static $_allowClasses = array(
		'XenForo_ControllerPublic_Login',
		'XenForo_ControllerPublic_Logout',

		'XenForo_ControllerPublic_Error', // error page!
		'XenForo_ControllerPublic_Account'
	);

	public static function controller_pre_dispatch(XenForo_Controller $controller, $action) {
		$manual = false;
		if ($controller instanceof XenForo_ControllerPublic_Abstract
			&& get_class($controller) != self::ERROR_CONTROLLER_CLASS
		)
		{
			$routeMatch = $controller->getRouteMatch();
			if ($routeMatch instanceof XenForo_RouteMatch) {
				$manual = true;
			}
		}

		if ($manual)
		{
			if (!in_array($routeMatch->getControllerName(), self::$_allowClasses))
			{
				if (Nobita_PasswordRules_Password::hasForceUpdatePassword())
				{
					$visitor = XenForo_Visitor::getInstance();
					throw $controller->responseException(
						$controller->responseError(new XenForo_Phrase('password_rules_force_to_update_password_message',
							array(
								'username' => $visitor['username'],
								'update_password' => XenForo_Link::buildPublicLink('account/security')
							)
						)), 403
					);
				}
			}
		}
	}


}