<?php
class Nobita_PasswordRules_Option {
	public static function getUserGroupOptions($selectedGroup, $unspecifiedPhrase = false) {
		/* @var $userGroupModel XenForo_Model_UserGroup */
		$userGroupModel = XenForo_Model::create('XenForo_Model_UserGroup');
		$options = $userGroupModel->getUserGroupOptions($selectedGroup);

		if ($unspecifiedPhrase) {
			$options = array_merge(array(array
			(
				'label' => $unspecifiedPhrase,
				'value' => 0,
				'selected' => ($selectedGroup == 0)
			)), $options);
		}

		return $options;
	}

	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit) {
		$preparedOption['formatParams'] = self::getUserGroupOptions(
			$preparedOption['option_value'],
			sprintf('(%s)', new XenForo_Phrase('unspecified'))
		);

		return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
			'passwordRules_option_user_groups', $view, $fieldPrefix, $preparedOption, $canEdit
		);
	}
}