<?php

class Nobita_PasswordRules_Password {
	public static function preVerifyPassword(XenForo_Controller $controller, XenForo_DataWriter $writer, $password, $update = true) {
		if (self::getOption('minLength')) {
			if (strlen($password) < self::getOption('minLength')) {
				$writer->error(new XenForo_Phrase('password_at_least_x_characters_long', array('count' => self::getOption('minLength'))));
			}
		}

		if (self::getOption('upperCase')) {
			// verify if have an upper case!
			if (!preg_match('/[A-Z]/', $password)) {
				$writer->error(new XenForo_Phrase('password_must_have_an_least_a_upper_character'));
			}
		}

		if (self::getOption('number')) {
			// check number!
			if (!preg_match('/[0-9]/', $password)) {
				$writer->error(new XenForo_Phrase('password_must_have_an_least_number'));
			}
		}
	
		if (self::getOption('specialCharacters')) {
			// check special characters
			if (!preg_match('/[^\da-zA-Z]/', $password)) {
				$writer->error(new XenForo_Phrase('password_must_have_an_least_special_character'));
			}
		}

		if (self::getOption('prohibitionWords')) {
			if ($update) {
				$user = XenForo_Visitor::getInstance()->toArray();
				
				$username = $user['username'];
				$email = $user['email'];
			} else {
				$username = $controller->getInput()->filterSingle('username', XenForo_Input::STRING);
				$email = $controller->getInput()->filterSingle('email', XenForo_Input::STRING);
			}

			if (strpos($password, $username) !== false) {
				$writer->error(new XenForo_Phrase('password_exclude_user_personal_information'));
			}

			$email = explode("@", $email);
			// fixed `strpos(): Empty needle`
			if (!empty($email[0]))
			{
				if (strpos($password, $email[0]) !== false)
				{
					$writer->error(new XenForo_Phrase('password_exclude_user_personal_information'));
				}
			}
		}

		if ($update)
		{
			$oldPassword = $controller->getInput()->filterSingle('old_password', XenForo_Input::STRING);
			if ($oldPassword === $password)
			{
				$writer->error(new XenForo_Phrase('password_cant_reuse_the_old_password'));
			}
		}

		// disable simple passwords. set in option!
		if (in_array($password, self::getDisallowedPasswords()))
		{
			$writer->error(new XenForo_Phrase('password_blacklist_try_to_another_password'));
		}

		if (self::getOption('keeptime') && $update) {
			$db = $writer->passwordRules_getDb();
			
			$oldData = $db->fetchAll('
				SELECT *
				FROM xf_password_rule
				WHERE user_id = ?
			', array(XenForo_Visitor::getUserId()));
			
			$passwordHash = new XenForo_PasswordHash(XenForo_Application::getConfig()->passwordIterations, false);
			if ($oldData) {
				foreach ($oldData as $data) {
					$stored = @unserialize($data['data']);
					if (isset($stored['hash']) && $passwordHash->CheckPassword($password, $stored['hash'])) {
						$writer->error(new XenForo_Phrase('password_cant_reuse_the_old_password'));
						break;
					}
				}
			}
		}
	}

	public static function getDisallowedPasswords() {
		return preg_split('/\s+/', trim(self::getOption('disablePasswords')));
	}

	/* Cache query to save resource... */
	protected static $hasUpdatedCache;

	/* Function force to user must update password to continue using forums! */
	public static function hasForceUpdatePassword(Zend_Db_Adapter_Abstract $db = null, array $viewingUser = null) {
		if ($viewingUser === null) $viewingUser = XenForo_Visitor::getInstance()->toArray();
		if ($db === null) $db = XenForo_Application::getDb();

		$groupsCheck = self::getOption('forceUpdatePass');
		if (empty($groupsCheck) || !$viewingUser['user_id']) return false; // nothing to do!

		if (!self::$hasUpdatedCache)
		{
			self::$hasUpdatedCache = $db->fetchRow('
				SELECT *
				FROM xf_password_rule
				WHERE user_id = ?
				ORDER BY date
			', array($viewingUser['user_id']));
		}

		if (self::$hasUpdatedCache) return false; // user ready to change password before.

		$groupIds = $viewingUser['user_group_id'];
		if ($viewingUser['secondary_group_ids'] != '') {
			$groupIds .=', ' . $viewingUser['secondary_group_ids'];
		}

		$groups = array_map("intval", explode(',', $groupIds));
		unset($groupIds);

		foreach ($groups as $groupId) {
			if (in_array($groupId, $groupsCheck)) return true; // belong to group check!
		}

		return false;
	}

	public static function storeData(XenForo_DataWriter $writer, $userId, $data) {
		$db = $writer->passwordRules_getDb();

		// you dont want to store! Nothing to do.
		if (!self::getOption('keeptime')) return false;

		try
		{
			$db->insert('xf_password_rule', array(
				'user_id' => $userId,
				'data' => $data,
				'date' => XenForo_Application::$time
			));
		}
		catch (Zend_Db_Exception $e) {}
	}

	public static function removeOldData($filterDate = 0) {
		if (!$filterDate)
			$filterDate = XenForo_Application::$time - self::getOption('keeptime') * 86400; // days

		$db = XenForo_Application::get('db');
		$db->delete('xf_password_rule', 'date < ' . $db->quote($filterDate));
	}

	public static function getOption($key) {
		return XenForo_Application::get('options')->get(sprintf('passwordRules_%s', $key));
	}
}