<?php
class Nobita_UserPreview_ControllerPublic_Member extends XFCP_Nobita_UserPreview_ControllerPublic_Member
{
	public function actionPreview()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		
		$userModel = $this->_getUserModel();
		
		$userFetchOptions = array(
			'join' => XenForo_Model_User::FETCH_LAST_ACTIVITY
		);
		$user = $this->getHelper('UserProfile')->getUserOrError($userId, $userFetchOptions);
		
		$visitor = XenForo_Visitor::getInstance();
		$userModel = $this->_getUserModel();
		
		// get last activity details
		$user['activity'] = ($user['view_date'] ? $this->getModelFromCache('XenForo_Model_Session')->getSessionActivityDetails($user) : false);
		
		$user['isFollowingVisitor'] = $userModel->isFollowing($visitor['user_id'], $user);
		
		$canCleanSpam = (XenForo_Permission::hasPermission($visitor['permissions'], 'general', 'cleanSpam') && $userModel->couldBeSpammer($user));
		
		$viewParams = array(
			'user' => $user,

			'canViewOnlineStatus' => $userModel->canViewUserOnlineStatus($user),
			'canStartConversation' => $userModel->canStartConversationWithUser($user),
			'canViewWarnings' => $userModel->canViewWarnings()
		);
		
		return $this->responseView('Nobita_UserPreview_ViewPublic_Member_Preview', 'user_preview', $viewParams);
	}
}