<?php
    class PHCTags_BbCode_Formatter_Base extends XFCP_PHCTags_BbCode_Formatter_Base
    {
        public function renderHashTag($matches)
        {            
            if (strlen($matches[1]) >= XenForo_Application::getOptions()->minimumhashlength)
            {
                $link = XenForo_Link::buildPublicLink('full:hashtags', array('phrase' => $matches[1]));
                
                $prefix = XenForo_Application::getOptions()->keephashtag ? '#' : '#';

		return parent::_wrapInHtml('<a href="' . htmlspecialchars($link) . '" class="hashtag OverlayTrigger">', '</a>', $prefix . $matches[1]);
            }
            else
            {
                return '#' . $matches[1];
            }
        }
        public function renderString($string, array $rendererStates, &$trimLeadingLines)
	{
            $string = parent::renderString($string, $rendererStates, $trimLeadingLines);
            $string = preg_replace_callback('/(?![\"|\{]#.*)#([a-zA-Z_]+)/', array($this, 'renderHashTag'), $string);

            return $string;
	}
    }
?>