<?php
class PHCTags_ControllerPublic_Index extends XenForo_ControllerPublic_Abstract
{
        public function __construct($request, $response, $routeMatch)
        {
            return parent::__construct($request, $response, $routeMatch);
        }
        protected function _preDispatch($action)
	{
            parent::_preDispatch($action);
            $this->_visitor = XenForo_Visitor::getInstance();
            $this->perms = $this->_visitor->getPermissions();
        }
        public function actionTest()
        {
            var_dump(XenForo_Model::create('XenForo_Model_DataRegistry')->get('TaggedContent'));
        }
        public function actionCloud()
	{            
            $params = array();
            $params['h1'] = new XenForo_Phrase('phctags_trending_header');
            $params['description'] = new XenForo_Phrase('phctags_trending_description');
            
            $params['topics'] = XenForo_Model::create('PHCTags_Model_Posts')->__trendingTopics(
                    time() - (60*60*24*XenForo_Application::getOptions()->phctags_maxpostage)
            );
            
            return $this->responseView('PHCTags', 'PHCTags_Cloud', $params);
        }
	public function actionIndex()
	{            
            $hashtag = $this->_input->filterSingle('phrase', XenForo_Input::STRING);
            
            $params = array();
            
            if (!empty($hashtag))
            {
                $params['tag'] = $hashtag;

                $params['groups'][] = array(
                    'tag' => $hashtag,
                    'posts' => XenForo_Model::create('PHCTags_Model_Posts')->__loadTag($hashtag)
                );

                return $this->responseView('PHCTags_View', 'PHCTags', $params);
            }
            else
            {
                $params = array();
                $params['h1'] = new XenForo_Phrase('phctags_trending_header');
                $params['description'] = new XenForo_Phrase('phctags_trending_description');

                $params['posts'] = XenForo_Model::create('PHCTags_Model_Posts')->__loadTag('');
                $params['groups'] = XenForo_Model::create('PHCTags_Model_Posts')->__trendingTopics(
                        time() - (60*60*24*XenForo_Application::getOptions()->phctags_maxpostage), true, 5, true
                );

                return $this->responseView('PHCTags_View', 'PHCTags', $params);
            }
        }
}