<?php
    class PHCTags_Model_Posts Extends XenForo_Model
    {
        var $users = array();
        var $postPermissions = array();
        public function __loadTag($tag, $timeSearch = false)
        {
            $posts = array();
            
            $postModel = XenForo_Model::create('XenForo_Model_Post');
            
            $get = $this->getModelFromCache('XenForo_Model_DataRegistry')->get('TaggedContent');
            for ($t = 0; $t < count($get); $t++)
            {
                if (strtolower($get[$t]['tag']) == strtolower($tag))
                {
                    for ($i = 0; $i < count($get[$t]['posts']); $i++)
                    {
                        $post = $get[$t]['posts'][$i];
                        if (empty($this->postPermissions[$post['post_id']]))
                                $this->postPermissions[$post['post_id']] = $postModel->canViewPost($post, $post, $post);
                        if ($this->postPermissions[$post['post_id']])
                        {
                            if (empty($this->users[$post['user_id']]))
                                $this->users[$post['user_id']] = $this->getModelFromCache('XenForo_Model_User')->getUserById($post['user_id'], array('join' => Xenforo_Model_User::FETCH_USER_PROFILE));
                            $post['user'] = $this->users[$post['user_id']];
                            $posts[] = $post;
                        }
                    }
                }
            }
            
            return $posts;            
        }
        public function __dbLoadTag($tag, $timeSearch = false)
        {
            $posts = array();
            
            $postModel = XenForo_Model::create('XenForo_Model_Post');            
            $time = ($timeSearch === true) ? (time() - (60*60*24*XenForo_Application::getOptions()->phctags_maxpostage)) : 0;
            
            if (strlen($tag) >= XenForo_Application::getOptions()->minimumhashlength)
            {
                $get = $this->_getDb()->fetchAll("SELECT n.*, t.*, p.* FROM xf_post p LEFT JOIN xf_thread t ON t.thread_id = p.thread_id LEFT JOIN xf_node n ON n.node_id = t.node_id WHERE p.message REGEXP ? and p.post_date > ? ORDER BY p.post_date DESC LIMIT 25", array('#' . $tag, $time));
                for ($i = 0; $i < count($get); $i++)
                {
                    if (empty($this->users[$get[$i]['user_id']]))
                        $this->users[$get[$i]['user_id']] = $this->getModelFromCache('XenForo_Model_User')->getUserById($get[$i]['user_id'], array('join' => Xenforo_Model_User::FETCH_USER_PROFILE));
                    if (empty($this->postPermissions[$get[$i]['post_id']]))
                        $this->postPermissions[$get[$i]['post_id']] = $postModel->canViewPost($get[$i], $get[$i], $get[$i]);
                    if ($this->postPermissions[$get[$i]['post_id']])
                    {
                        $get[$i]['user'] = $this->users[$get[$i]['user_id']];
                        $get[$i]['message'] = $get[$i]['message'];
                        $posts[] = $get[$i];
                    }
                }
                return $posts;
            }
            else
            {
                return array();
            }
        }
        public function getAllTaggedContent()
        {
            $taggedContent = array();
            $bbCodeParser = XenForo_BbCode_Parser::create(XenForo_BbCode_Formatter_Base::create('Base'));
            $tagsUsed = array();            
            $time = (time() - (60*60*24*XenForo_Application::getOptions()->phctags_maxpostage));
            $get = $this->_getDb()->fetchAll("SELECT n.*, t.*, p.* FROM xf_post p LEFT JOIN xf_thread t ON t.thread_id = p.thread_id LEFT JOIN xf_node n ON n.node_id = t.node_id WHERE p.message REGEXP '#([a-zA-Z_]+)' and p.post_date > ? ORDER BY p.post_date DESC", array($time));
            for ($i = 0; $i < count($get); $i++)
            {
                preg_match_all('/(?![\"|\{]#.*)#([a-zA-Z]+)/', strip_tags($bbCodeParser->render($get[$i]['message']), '<div><blockquote>'), $matches);
                for ($x = 0; $x < count($matches[1]); $x++)
                {
                    if (strlen($matches[1][$x]) >= XenForo_Application::getOptions()->minimumhashlength)
                        $tagsUsed[strtolower($matches[1][$x])] = (isset($tagsUsed[strtolower($matches[1][$x])])) ? $tagsUsed[strtolower($matches[1][$x])] + 1 : 1;
                }
            }
            
            if (count($tagsUsed) > 0)
            {
                arsort($tagsUsed);
                foreach ($tagsUsed as $tag => $occurances)
                {                    
                    $link = XenForo_Link::buildPublicLink('full:hashtags', array('phrase' => $tag));
                
                    $prefix = XenForo_Application::getOptions()->keephashtag ? '#' : '#';
                    
                    $class = 'OverlayTrigger hashtag';
                    $class .= ($occurances >= XenForo_Application::getOptions()->tagmentionsforpopular) ? ' popular' : '';

                    $tagHtml = '<a href="' . htmlspecialchars($link) . '" class="' . $class . '">' . $prefix . $tag . '</a>';
                    
                    $taggedContent[] = array(
                        'tag' => $tag,
                        'tagHtml' => $tagHtml,
                        'amount' => $occurances,
                        'posts' => $this->__dbLoadTag($tag, true)
                    );
                }
            }
            
            return $taggedContent;
        }
        public function __trendingTopics($time = 0, $getPosts = false, $amount = 30, $sortPopular = true)
        {
            $postModel = XenForo_Model::create('XenForo_Model_Post');
            
            $content = $this->getModelFromCache('XenForo_Model_DataRegistry')->get('TaggedContent');
            
            $tags = array();
            
            if (count($content) < $amount)
                $amount = count($content);
            
            for ($i = 0; $i < $amount; $i++)
            {
                
                for ($c = 0; $c < count($content[$i]['posts']); $c++)
                {
                    if (empty($this->postPermissions[$content[$i]['posts'][$c]['post_id']]))
                        $this->postPermissions[$content[$i]['posts'][$c]['post_id']] = $postModel->canViewPost($content[$i]['posts'][$c], $content[$i]['posts'][$c], $content[$i]['posts'][$c]);
                    if ($this->postPermissions[$content[$i]['posts'][$c]['post_id']])
                    {
                        $content[$i]['posts'][$c]['message'] = $content[$i]['posts'][$c]['message'];
                    }
                    else
                    {
                        unset($content[$i]['posts'][$c]);
                    }
                }
                
                $tags[] = $content[$i];
            }
            
            return $tags;
        }
    }
?>