<?php
/*======================================================================*\
|| #################################################################### ||
|| # New User Notification System  2.1
|| # Build: 25
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/


/* Start auto-generated lines of code. Change made will be overwriten... */

/**
 * NUNS phrase edit controller
 *
 */
class Ragtek_NUNS_ControllerAdmin_NUNS extends XenForo_ControllerAdmin_Abstract{

    /**
     * template name of the acp phrases edit page
     * @var string
     */
    protected $_template = 'ragtek_nuns_language';

    /**
     * phrase prefix, which is used to filter  the addon phrases
     * @var string
     */
    protected $_phrasePrefix = 'ragtek_nuns_text';

    /**
     * returns a language chooser or redirects to the phrase list if only 1 language is installed
     *
     * @return XenForo_ControllerResponse_Redirect|XenForo_ControllerResponse_View
     */
    public function actionIndex()
    {
        /** @var XenForo_Model_Language */
        $languages = $this->getModelFromCache('XenForo_Model_Language');

        $languages = $languages->getAllLanguages();



        $output = array();
        foreach ($languages AS $language) {
            $output[$language['language_id']] = htmlspecialchars($language['title']);
        }
        if (count($languages) == 1) {
            return $this->_redirect($language['language_id']);
        }
        $viewParams = array(
            'languages' => $output,
        );

        return $this->responseView('', $this->_template, $viewParams);
    }

    /**
     * gets the language id and redirects to the phrase list
     * @return XenForo_ControllerResponse_Redirect
     */
    public function actionEdit()
    {
        $this->_assertPostOnly();

        $language_id = $this->_input->filterSingle('language', XenForo_Input::UINT);
        return $this->_redirect($language_id);
    }

    /**
     * redirects to the phrase list
     * @param $languageId
     * @return XenForo_ControllerResponse_Redirect
     */
    protected function _redirect($languageId){
        $link = 'admin.php?language_id=' . $languageId .
                '&title=' . $this->_phrasePrefix .'&phrase_state[]=default&phrase_state[]=inherited&phrase_state[]=custom&search=1&_=phrases%2Fsearch';
        return $this->responseRedirect(
            XenForo_ControllerResponse_Redirect::SUCCESS,
            $link
        );
    }
}