<?php
/*======================================================================*\
|| #################################################################### ||
|| # New User Notification System  2.1
|| # Build: 25
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/


/**
 * Class provides Validators for NUNS xenforo options
 */
class Ragtek_NUNS_Option
{

    /**
     * option model
     * @var  XenForo_Model_User
     */
    protected static $_userModel = null;

    public static function verifyWelcomeThread($threadID, XenForo_DataWriter $dw, $fieldName)
    {

        if ($dw->isInsert() OR $threadID == '') {
            return true;
        }
        /** @var $threadModel XenForo_Model_Thread */
        $threadModel = XenForo_Model::create('XenForo_Model_Thread');

        if ($thread = $threadModel->getThreadById($threadID)) {
            return true;
        }
        $dw->error(new XenForo_Phrase('ragtek_nuns_invalid_threadid'));
        return false;


    }

    /**
     * callback class for nuns username options
     * @static
     * @param $username
     * @param XenForo_DataWriter $dw
     * @param $fieldName
     * @return bool
     */
    public static function verifyOption($username, XenForo_DataWriter $dw, $fieldName)
    {

        if ($dw->isInsert()) {
            return true;
        }

        if ($username != '') {
            if (self::_getUserModel()->getUserByName($username)) {
                return true;
            } else {
                switch ($fieldName) {
                    case 'ragtek_NUNS_welcomeConversationSender':
                        $field = 'conversation creater';
                        break;
                    case 'ragtek_NUNS_newUserThreadCreater':
                        $field = 'thread creator';
                        break;
                    case 'ragtek_NUNS_ProfilePostCreater':
                        $field = 'profilePost Creator';
                        break;
                    case 'ragtek_NUNS_welcomePostCreater':
                        $field = 'welcome post Creator';
                        break;
                }
                $dw->error(new XenForo_Phrase('invalid_username') . ' used in field ' . $field);
                return false;
            }
        }
    }

    /**
     * @static
     * @return XenForo_Model_User
     */
    protected static function _getUserModel()
    {
        if (!self::$_userModel) {
            self::$_userModel = XenForo_Model::create('XenForo_Model_User');
        }
        return self::$_userModel;
    }

    /**
     * shows the
     * @static
     * @param XenForo_View $view
     * @param $fieldPrefix
     * @param array $preparedOption
     * @param $canEdit
     * @return XenForo_Template_Abstract
     */
    public static function showPhraseOptions(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {

        $editLink = $view->createTemplateObject('option_list_option_editlink', array(
            'preparedOption' => $preparedOption,
            'canEditOptionDefinition' => $canEdit
        ));

        $jsTemplate = $view->createTemplateObject('ragtek_nuns_option_js', array(
            'editlink' => $editLink,
            'preparedOption' => $preparedOption));

        return $view->createTemplateObject('ragtek_nuns_options_phrase', array(
            'editlink' => $editLink,
            'preparedOption' => $preparedOption,
        )) . $jsTemplate;
    }
}