<?php

class RainDD_ThreadActivity_Controller_ReadThread extends XFCP_RainDD_ThreadActivity_Controller_ReadThread
{

	public function actionIndex()
	{
		$response = parent::actionIndex();
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		$threadModel = $this->getModelFromCache('XenForo_Model_Thread');
		
		if ($threadModel->isRedirect($thread))
		{
			return $response;
		}
		else
		{
			$visitor = XenForo_Visitor::getInstance();
			$hasPermission =  $visitor->hasPermission('raindd_ta_permissions', 'raindd_ta_viewread');
			if ($response instanceof XenForo_ControllerResponse_View && $hasPermission)
			{
				$threadId = $response->params['thread']['thread_id'];
				$readUsersModel = $this->getModelFromCache('RainDD_ThreadActivity_Model_ReadThread');
				$readUsers = $readUsersModel->getReadUsers($threadId);
				$count = count($readUsers);		
				$response->params += array('raindd_threadactivity_usersreadthread' => $readUsers, 
											'raindd_threadactivity_readpermission' => $hasPermission,
											'raindd_threadactivity_usercount' => $count);		
			}		
		return $response;         
		}

	}

}