<?php

class RainDD_ThreadActivity_Controller_ViewingThread extends XFCP_RainDD_ThreadActivity_Controller_ViewingThread
{

	public function actionIndex()
	{
		$response = parent::actionIndex();
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		$threadModel = $this->getModelFromCache('XenForo_Model_Thread');
					
		if ($threadModel->isRedirect($thread))
		{
			return $response;
		}
		else
		{
			$visitor = XenForo_Visitor::getInstance();
			$hasPermission =  $visitor->hasPermission('raindd_ta_permissions', 'raindd_ta_viewviewers');
			if ($response instanceof XenForo_ControllerResponse_View && $hasPermission)
			{
				$threadId = $response->params['thread']['thread_id'];
				$viewing = $this->getModelFromCache('RainDD_ThreadActivity_Model_ViewThread');
				$response->params += array('raindd_threadactivity_usersviewingthread' => $viewing->getUsersViewingThread($threadId),
											'raindd_threadactivity_viewpermission' => $hasPermission,
				);
			}
			return $response; 
		}					        
	}
}