<?php
/*======================================================================*\
|| #################################################################### ||
|| # Country Flags for XenForo                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2014 Snog. All Rights Reserved.                      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| #                http://www.snogssite.com/forum                    # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_CountryFlags_Install
{
	public static function install($installedAddon)
	{
		if(!function_exists('bcadd'))
		{
			throw new XenForo_Exception('BC Math is either not installed on your server or PHP is not compiled with it enabled.', true);
		}

		if (!self::checkExist('xf_user','snog_flag'))
		{
			$db = XenForo_Application::get('db');
			$db->query("ALTER TABLE `xf_user` 
				ADD `snog_country` varchar(50) NOT NULL DEFAULT '' COLLATE utf8_general_ci,
				ADD `snog_flag` varchar(3) NOT NULL DEFAULT '' COLLATE utf8_general_ci");
		}

		$path = 'data/countryflags/GeoLite2-Country.mmdb.gz';
		$ch = curl_init ('http://geolite.maxmind.com/download/geoip/database/GeoLite2-Country.mmdb.gz');
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
		$raw=curl_exec($ch);
		curl_close ($ch);
		$fp = fopen($path,'w');
		fwrite($fp, $raw);
		fclose($fp);

		$uncompressed = '';
		$zip = @gzopen($path, 'rb');
		if($zip !== false)
		{
			while(!gzeof($zip))
			{
				$uncompressed .= @gzread($zip, 102400);
			}

			@gzclose($zip);
		}else{
			throw new XenForo_Exception('Error downloading and extracting GeoLite2 database.', true);
		}

		$fp = fopen('data/countryflags/GeoLite2-Country.mmdb','w');
		fwrite($fp, $uncompressed);
		fclose($fp);
		unlink($path);
	}
	
	public static function uninstall()
	{
		$db = XenForo_Application::get('db');
		$db->query("ALTER TABLE `xf_user` DROP `snog_country`,
			DROP `snog_flag`");
	}

	public static function checkExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW columns FROM `' . $table . '` WHERE Field = ?', $field)) {
			return true;
		}else{
			return false;
		}
	}
}