<?php
/*======================================================================*\
|| #################################################################### ||
|| # Country Flags for XenForo                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2014 Snog. All Rights Reserved.                      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| #                http://www.snogssite.com/forum                    # ||
|| #################################################################### ||
\*======================================================================*/

require_once __DIR__ . '/Includes/Reader.php'; 
require_once __DIR__ . '/Includes/Reader/Decoder.php'; 
require_once __DIR__ . '/Includes/Reader/InvalidDatabaseException.php'; 
require_once __DIR__ . '/Includes/Reader/Metadata.php';
require_once __DIR__ . '/Includes/Reader/Util.php';
use Countryflags\Db\Reader;
define('CFDB_FOLDER', str_ireplace('library/Snog/CountryFlags/Listener','',__DIR__));

class Snog_CountryFlags_Listener_Visitor 
{
	public static function visitor(&$visitor) 
	{
		if($visitor['user_id'] > 0)
		{
			$ipaddress = 'UNKNOWN';
			$tempaddress = array();
			$user_flag = 'A1';
			$user_country = 'Unknown';
			if($_SERVER['REMOTE_ADDR']) $ipaddress = $_SERVER['REMOTE_ADDR'];

			// FIX FOR OPERA MINI PROXIES
			if(isset($_SERVER['HTTP_X_FORWARDED_FOR']) && strpos($_SERVER['HTTP_X_FORWARDED_FOR'],','))
			{
				$tempaddress = explode(',',$_SERVER['HTTP_X_FORWARDED_FOR']);
				foreach($tempaddress as $checkip)
				{
					if(self::isvalid_ip(trim($checkip)))
					{
						$ipaddress = trim($checkip);
						break;
					}
				}
			}else if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])){
				$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
			}
			
			if(self::isvalid_ip($ipaddress))
			{
				$reader = new Reader(CFDB_FOLDER . '/data/countryflags/GeoLite2-Country.mmdb');
				$record = $reader->get($ipaddress);

				if($record)
				{
					if(isset($record['country']))
					{
						$user_flag = $record['country']['iso_code'];
						$user_country = $record['country']['names']['en'];
					}else if(isset($record['registered_country']))
					{
						$user_flag = $record['registered_country']['iso_code'];
						$user_country = $record['registered_country']['names']['en'];
					}
				}
			}else{
				if($ipaddress !== 'UNKNOWN')
				{
					if(strpos($ipaddress,'10.') !== false && strpos($ipaddress,'10.') == 0)
					{
						$user_flag = 'LO';
						$user_country = 'Local Intranet';
					}

					if(strpos($ipaddress,'172.') !== false && strpos($ipaddress,'172.') == 0)
					{
						$iplong = ip2long($ipaddress);
						if($iplong >= 2886729728 && $iplong <= 2887778303)
						{
							$user_flag = 'LO';
							$user_country = 'Local Intranet';
						}
					}

					if(strpos($ipaddress,'192.168') !== false && strpos($ipaddress,'192.168') == 0)
					{
						$user_flag = 'LO';
						$user_country = 'Local Intranet';
					}

					if($user_flag !== 'LO')
					{
						$user_flag = 'ZZ';
						$user_country = 'Reserved';
					}
				}
			}

			if($visitor['snog_flag'] <> $user_flag)
			{
				$db = XenForo_Application::get('db');

				$db->query("UPDATE xf_user
					SET `snog_country` = '" . $user_country . "',
					`snog_flag` = '" . $user_flag . "'
					WHERE `user_id` = " . $visitor['user_id'] . ""
				);
			}
		}
		return;
	}

	public static function isvalid_ip($ip, $include_priv_res = false)
	{
		return $include_priv_res ?
			filter_var($ip, FILTER_VALIDATE_IP) !== false :
			filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false;
	}
}