<?php
/*======================================================================*\
|| #################################################################### ||
|| # Country Flags for XenForo                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2014 Snog. All Rights Reserved.                      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| #                http://www.snogssite.com/forum                    # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_CountryFlags_Model_GetUserGroups extends XenForo_Model
{
	public function getUserGroupOptions($selectedGroupIds)
	{
		$userGroups = array();

		foreach ($this->getAppropriateUserGroups() AS $userGroup)
		{
			$userGroups[] = array(
				'label' => $userGroup['title'],
				'value' => $userGroup['user_group_id'],
				'selected' => in_array($userGroup['user_group_id'], $selectedGroupIds)
			);
		}

		return $userGroups;
	}

	public function getAppropriateUserGroups()
	{
		return $this->_getDb()->fetchAll('
			SELECT user_group_id, title
			FROM xf_user_group
			ORDER BY title
		');
	}
}

