<?php

class SocialConnect_ControllerPublic_Account extends XFCP_SocialConnect_ControllerPublic_Account
{
	public function actionSocialConnect()
	{
		$visitor = XenForo_Visitor::getInstance();
		
		$options = XenForo_Application::get('options');
		
		$facebookDisabled = false;
		if (!$options->socialConnectFacebookAppId || !$options->socialConnectFacebookAppSecret)
		{
			$facebookDisabled = true;
		}
		
		$twitterDisabled = false;
		if (!$options->socialConnectTwitterConsumerKey || !$options->socialConnectTwitterConsumerSecret)
		{
			$twitterDisabled = true;
		}
		
		if ($facebookDisabled && $twitterDisabled)
		{
			return $this->responseNoPermission();
		}
		
		$token = SocialConnect_Helper_Twitter::getRequestToken();		
		$tokens = XenForo_Application::parseQueryString($token);
		
		$authoriseUri = '';
		
		if (isset($tokens['oauth_token']))
		{
			$authoriseUri = "http://api.twitter.com/oauth/authorize?oauth_token=$tokens[oauth_token]";
		}
		
		// Facebook requires a specially encoded URL keep it simple and force non friendly URL. Doesn't matter, no one sees it.
		$prefix = $options->boardUrl . '/index.php?';
		$suffix = urlencode('account/social-connect/callback');
		$redirectUri = $prefix . $suffix;
		
		$fbAuthoriseUri = SocialConnect_Helper_Facebook::getFacebookLogin($redirectUri);
		
		$viewParams = array(
			'canUpdateStatus' => $visitor->canUpdateStatus(),
			'authoriseUri' => $authoriseUri,
			'fbAuthoriseUri' => $fbAuthoriseUri,
			'tokens' => unserialize($visitor['social_tokens']),
		);		
		
		return $this->_getWrapper(
			'account', 'socialConnect',
			$this->responseView(
				'SocialConnect_ViewPublic_Account_SocialConnect',
				'social_connect_account_settings',
				$viewParams
			)
		);		
	}
	
	public function actionSocialConnectCallback()
	{	
		$visitor = XenForo_Visitor::getInstance();
		$social_tokens = unserialize($visitor['social_tokens']);
		
		// Twitter Tokens
		$oauth_token = $this->_input->filterSingle('oauth_token', XenForo_Input::STRING);
		$oauth_verifier = $this->_input->filterSingle('oauth_verifier', XenForo_Input::STRING);
		
		// Facebook Tokens
		$state = $this->_input->filterSingle('state', XenForo_Input::STRING);
		$code = $this->_input->filterSingle('code', XenForo_Input::STRING);
		
		if ($oauth_token)
		{
			$access_tokens = SocialConnect_Helper_Twitter::getAccessToken($oauth_token, $oauth_verifier);
			
			$access_tokens = XenForo_Application::parseQueryString($access_tokens);
			
			$social_tokens['twitter'] = $access_tokens;
			$social_tokens['twitter'] += array(
				'status' => true,
				'thread' => true,
				'trophy' => true
			);
		}
		elseif ($state || $code)
		{
			if ($state && $state != $visitor['csrf_token'])
			{
				return $this->responseError(new XenForo_Phrase('security_error_occurred'));
			}
			
			if ($code)
			{
				$options = XenForo_Application::get('options');
				
				// Facebook requires a specially encoded URL keep it simple and force non friendly URL. Doesn't matter, no one sees it.
				$prefix = $options->boardUrl . '/index.php?';
				$suffix = urlencode('account/social-connect/callback');
				$redirectUri = $prefix . $suffix;		
				
				$access_tokens = SocialConnect_Helper_Facebook::getAccessToken($code, $redirectUri);
				
				//$access_tokens['expires'] = XenForo_Application::$time + $access_tokens['expires'];
				
				$social_tokens['facebook'] = $access_tokens;
				$social_tokens['facebook'] += array(
					'status' => true,
					'thread' => true,
					'trophy' => true
				);
			}
		}
		
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
		
		$writer->setExistingData($visitor['user_id']);		
		$writer->set('social_tokens', serialize($social_tokens));
		$writer->save();
		
		return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('account/social-connect')
		);
	}
	
	public function actionSocialConnectAdminCallback()
	{
		// Facebook Tokens
		$state = $this->_input->filterSingle('state', XenForo_Input::STRING);
		$code = $this->_input->filterSingle('code', XenForo_Input::STRING);
		
		$visitor = XenForo_Visitor::getInstance();
		if ($visitor['is_admin'])
		{
			if ($state && $state != $visitor['csrf_token'])
			{
				return $this->responseError(new XenForo_Phrase('security_error_occurred'));
			}
			
			if ($code)
			{
				$options = XenForo_Application::get('options');
				
				// Facebook requires a specially encoded URL keep it simple and force non friendly URL. Doesn't matter, no one sees it.
				$prefix = $options->boardUrl . '/index.php?';
				$suffix = urlencode('account/social-connect/admin-callback');
				$redirectUri = $prefix . $suffix;				
				
				$access_tokens = SocialConnect_Helper_Facebook::getAccessToken($code, $redirectUri);
				
				//$access_tokens['expires'] = XenForo_Application::$time + $access_tokens['expires'];
				
				$social_tokens['facebook'] = $access_tokens;
				$social_tokens['facebook'] += array(
					'status' => true,
					'thread' => true,
					'trophy' => true
				);
				
				$db = XenForo_Application::getDb();
				$db->update('xf_option', array('option_value' => serialize(array('fbAdminAccessToken' => $access_tokens['access_token']))), 'option_id = "socialConnectFacebookAdminToken"');
				XenForo_Model::create('XenForo_Model_Option')->rebuildOptionCache();
				
				$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
				
				$writer->setExistingData($visitor['user_id']);		
				$writer->set('social_tokens', serialize($social_tokens));
				$writer->save();			    
				
				return $this->responseRedirect(
						XenForo_ControllerResponse_Redirect::SUCCESS,
						XenForo_Link::buildAdminLink('options/list/socialConnect'),
						'Your changes have been saved.'
				);
			}				
		}		
	}
	
	public function actionSocialConnectUnlinkTwitter()
	{
		if ($this->isConfirmedPost())
		{
			$visitor = XenForo_Visitor::getInstance();
			
			$social_tokens = unserialize($visitor['social_tokens']);
			
			if (isset($social_tokens['twitter']))
			{
				unset ($social_tokens['twitter']);
			}
			
			$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
			
			$writer->setExistingData($visitor['user_id']);
			$writer->set('social_tokens', serialize($social_tokens));
			$writer->save();

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('account/social-connect')
			);
		}
		else
		{
			$viewParams = array(
				'service' => 'twitter',
			);
			return $this->responseView('SocialConnect_ViewPublic_Account_SocialConnectUnlinkTwitter', 'social_connect_account_unlink', $viewParams);
		}		
	}
	
	public function actionSocialConnectUnlinkFacebook()
	{
		if ($this->isConfirmedPost())
		{
			$visitor = XenForo_Visitor::getInstance();
			
			$social_tokens = unserialize($visitor['social_tokens']);
			
			if (isset($social_tokens['facebook']))
			{
				unset ($social_tokens['facebook']);
			}
			
			$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
			
			$writer->setExistingData($visitor['user_id']);
			$writer->set('social_tokens', serialize($social_tokens));
			$writer->save();

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('account/social-connect')
			);
		}
		else
		{
			$viewParams = array(
				'service' => 'facebook',
			);
			return $this->responseView('SocialConnect_ViewPublic_Account_SocialConnectUnlinkFacebook', 'social_connect_account_unlink', $viewParams);
		}		
	}	
	
	public function actionSocialConnectSave()
	{
		$visitor = XenForo_Visitor::getInstance();
		
		$social_tokens = unserialize($visitor['social_tokens']);
		
		$settings = $this->_input->filter(array(
			'twitter_status' => XenForo_Input::UINT,
			'twitter_thread' => XenForo_Input::UINT,
			'twitter_trophy' => XenForo_Input::UINT,
			'facebook_status' => XenForo_Input::UINT,
			'facebook_thread' => XenForo_Input::UINT,
			'facebook_trophy' => XenForo_Input::UINT,			
		));
		
		$social_tokens['twitter']['status'] = $settings['twitter_status'];
		$social_tokens['twitter']['thread'] = $settings['twitter_thread'];
		$social_tokens['twitter']['trophy'] = $settings['twitter_trophy'];
		
		$social_tokens['facebook']['status'] = $settings['facebook_status'];
		$social_tokens['facebook']['thread'] = $settings['facebook_thread'];
		$social_tokens['facebook']['trophy'] = $settings['facebook_trophy'];		
		
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
		
		$writer->setExistingData($visitor['user_id']);
		$writer->set('social_tokens', serialize($social_tokens));
		$writer->save();

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('account/social-connect')
		);			
	}
}

