<?php

class SocialConnect_DataWriter_Discussion_Thread extends XFCP_SocialConnect_DataWriter_Discussion_Thread
{
	protected function _discussionPostSave()
	{
		$options = XenForo_Application::get('options');
		
		$facebookDisabled = false;
		if (!$options->socialConnectFacebookAppId || !$options->socialConnectFacebookAppSecret)
		{
			$facebookDisabled = true;
		}
		
		$twitterDisabled = false;
		if (!$options->socialConnectTwitterConsumerKey || !$options->socialConnectTwitterConsumerSecret)
		{
			$twitterDisabled = true;
		}
		
		if ($facebookDisabled && $twitterDisabled)
		{
			return parent::_discussionPostSave();
		}
				
		$visitor = XenForo_Visitor::getInstance();
		
		if(!isset($visitor['social_tokens']))
		{
			return parent::_discussionPostSave();
		}		
		
		$tokens = unserialize($visitor['social_tokens']);
		
		if ($this->isInsert())
		{			
			if (isset($tokens['twitter']) && !empty($tokens['twitter']['thread']) && !$twitterDisabled && $this->isInsert())
			{			
				$postId = $this->get('first_post_id');
				$postModel = $this->_getPostModel();
				
				$post = $postModel->getPostById($postId);
				
				$postLen = strlen($post['message']);

				$postUrl = XenForo_Template_Helper_Core::link('canonical:posts', $post);
				
				$post['message'] = XenForo_Helper_String::bbCodeStrip($post['message'], true);
				
				if (($postLen + 20) <= 139)
				{
					$post['message'] = $post['message'] . ' ' . $postUrl;
				}
				else
				{		
					$post['message'] = XenForo_Helper_String::wholeWordTrim($post['message'], 115);
					$post['message'] = $post['message'] . ' ' . $postUrl;
				}
				
				$tweet = SocialConnect_Helper_Twitter::postStatusUpdate($post['message'], $tokens['twitter']['oauth_token'], $tokens['twitter']['oauth_token_secret']);			
			}
			
			if (isset($tokens['facebook']) && !empty($tokens['facebook']['thread']) && !$facebookDisabled && $this->isInsert())
			{
				$postId = $this->get('first_post_id');
				$postModel = $this->_getPostModel();
				
				$post = $postModel->getPostById($postId);
								
				$postUrl = XenForo_Template_Helper_Core::link('canonical:posts', $post);
				
				//$time = XenForo_Application::$time;
				
				/*$expired = '';
				if ($time > $tokens['facebook']['expires'])
				{
					$expired = true;
				}*/
				
				$valid = SocialConnect_Helper_Facebook::checkTokenValidity($tokens['facebook']['access_token']);
				
				if (!$valid)
				{
					unset ($tokens['facebook']);
					
					$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
					$writer->setExistingData($visitor['user_id']);
					$writer->set('social_tokens', serialize($tokens));
					
					$writer->save();
					
					return false;
				}				
				$post['message'] = XenForo_Helper_String::bbCodeStrip($post['message'], true);
				
				$post['message'] = $post['message'] . ' ' . $postUrl;
				
				$statusUpdate = SocialConnect_Helper_Facebook::postStatusUpdate($post['message'], $tokens['facebook']['access_token']);
			}
		}

		return parent::_discussionPostSave();
	}	
}