<?php

class SocialConnect_DataWriter_DiscussionMessage_ProfilePost extends XFCP_SocialConnect_DataWriter_DiscussionMessage_ProfilePost
{
	protected function _messagePreSave()
	{
		// Overwrite the existing function. Not ideal. But gets over the 140 character limit.
		if ($this->get('user_id') == $this->get('profile_user_id') && $this->isChanged('message'))
		{
			// statuses are more limited than other posts
			$message = $this->get('message');
			$maxLength = 140;

			$message = preg_replace('/\r?\n/', ' ', $message);
			
			$tweetLength = SocialConnect_Helper_Twitter::countTweetLength($message);

			if ($tweetLength > $maxLength)
			{
				$this->error(new XenForo_Phrase('please_enter_message_with_no_more_than_x_characters', array('count' => $maxLength)), 'message');
			}

			$this->set('message', $message);
		}
	}
	
	protected function _messagePostSave()
	{
		$options = XenForo_Application::get('options');
		
		$facebookDisabled = false;
		if (!$options->socialConnectFacebookAppId || !$options->socialConnectFacebookAppSecret)
		{
			$facebookDisabled = true;
		}
		
		$twitterDisabled = false;
		if (!$options->socialConnectTwitterConsumerKey || !$options->socialConnectTwitterConsumerSecret)
		{
			$twitterDisabled = true;
		}
		
		if ($facebookDisabled && $twitterDisabled)
		{
			return parent::_messagePostSave();
		}
		
		$message = $this->get('message');
		
		$visitor = XenForo_Visitor::getInstance();
		
		if(!isset($visitor['social_tokens']))
		{
			return parent::_messagePostSave();
		}		
		
		$tokens = unserialize($visitor['social_tokens']);
		
		if (isset($tokens['twitter']) && $tokens['twitter']['status'] && !$twitterDisabled && $this->isInsert())
		{
			$profilePost = $this->getNewData();
			$profilePost = $profilePost['xf_profile_post'];
			
			$profilePostUrl = XenForo_Template_Helper_Core::link('canonical:profile-posts', $profilePost);					
			
			$postLen = strlen($profilePost['message']);
			
			if (($postLen + 20) <= 139)
			{
				$profilePost['message'] = $profilePost['message'] . ' ' . $profilePostUrl;
			}
			else
			{		
				$profilePost['message'] = XenForo_Helper_String::wholeWordTrim($profilePost['message'], 115);
				$profilePost['message'] = $profilePost['message'] . ' ' . $profilePostUrl;
			}
			
			$tweet = SocialConnect_Helper_Twitter::postStatusUpdate($profilePost['message'], $tokens['twitter']['oauth_token'], $tokens['twitter']['oauth_token_secret']);			
		}
		
		if (isset($tokens['facebook']) && $tokens['facebook']['status'] && !$facebookDisabled && $this->isInsert())
		{
			$profilePost = $this->getNewData();
			$profilePost = $profilePost['xf_profile_post'];
			
			$profilePostUrl = XenForo_Template_Helper_Core::link('canonical:profile-posts', $profilePost);	
			
			$valid = SocialConnect_Helper_Facebook::checkTokenValidity($tokens['facebook']['access_token']);
			
			if (!$valid)
			{
				unset ($tokens['facebook']);
				
				$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
				$writer->setExistingData($visitor['user_id']);
				$writer->set('social_tokens', serialize($tokens));
				
				$writer->save();
				
				return false;
			}
			
			$profilePost['message'] = $profilePost['message'] . ' ' . $profilePostUrl;
			
			$statusUpdate = SocialConnect_Helper_Facebook::postStatusUpdate($profilePost['message'], $tokens['facebook']['access_token']);
		}
		
		return parent::_messagePostSave();		
	}	
}