<?php

class SocialConnect_DataWriter_User extends XFCP_SocialConnect_DataWriter_User
{
	protected function _getFields()
	{
		$parent = parent::_getFields();
		
		$parent['xf_user'] += array(
			'social_tokens' => array('type' => self::TYPE_SERIALIZED, 'default' => '')
		);
		
		return $parent;
	}
	
	protected function _postSave()
	{
		if ($this->isInsert())
		{
			$fbToken = XenForo_Helper_Cookie::getCookie('fbToken');
			
			if ($fbToken)
			{
				$social_tokens = unserialize($this->get('social_tokens'));
				$social_tokens['facebook']['access_token'] = $fbToken;
				$social_tokens['facebook'] += array(
					'status' => true,
					'thread' => true,
					'trophy' => true
				);
				
				$db = $this->_db;

				$db->update('xf_user',
					array('social_tokens' => serialize($social_tokens)),
					'user_id = ' . $db->quote($this->get('user_id'))
				);					
				
				XenForo_Helper_Cookie::deleteCookie('fbToken');
			}
		}
		
		return parent::_postSave();
	}
}