<?php

class SocialConnect_Helper_Facebook
{
	public static function getFacebookLogin($redirectUri)
	{
		$options = XenForo_Application::get('options');
		
		$facebookAppId = $options->socialConnectFacebookAppId;
		$facebookAppSecret = $options->socialConnectFacebookAppSecret;
		
		if (!$facebookAppId || !$facebookAppSecret)
		{
			return false;
		}		
		
		$csrf_token = XenForo_Visitor::getInstance()->get('csrf_token');
		
		$loginUrl = 'https://graph.facebook.com/oauth/authorize?client_id='
			. $facebookAppId . '&redirect_uri=' . urlencode($redirectUri) . '&state='
			. $csrf_token . '&scope=publish_stream';
		
		return $loginUrl;
	}
	
	public static function getAccessToken($code, $redirectUri)
	{
		$options = XenForo_Application::get('options');		
		
		$facebookAppId = $options->socialConnectFacebookAppId;
		$facebookAppSecret = $options->socialConnectFacebookAppSecret;
		
		if (!$facebookAppId || !$facebookAppSecret)
		{
			return false;
		}
		
		try
		{
			$client = XenForo_Helper_Http::getClient('https://graph.facebook.com/oauth/access_token');
			$client->setParameterGet(array(
				'client_id' => $facebookAppId,
				'redirect_uri' => $redirectUri,
				'client_secret' => $facebookAppSecret,
				'code' => $code
			));

			$response = $client->request('GET');

			$body = $response->getBody();
			if (preg_match('#^[{\[]#', $body))
			{
				$parts = json_decode($body, true);
			}
			else
			{
				$parts = XenForo_Application::parseQueryString($body);
			}

			return $parts;
		}
		catch (Zend_Http_Client_Exception $e)
		{
			return false;
		}
	}
	
	public static function postStatusUpdate($message, $access_token)
	{
		try
		{
	        $client = XenForo_Helper_Http::getClient('https://graph.facebook.com/me/feed');
	        
	        $client->setParameterPost(array(
	                'access_token' => $access_token,
	                'message' => $message
	        ));
	       
	        $response = $client->request('POST');
		}
		catch (Zend_Http_Client_Exception $e)
		{
			return false;
		}        
        
        return $response;		
	}
	
    public static function checkTokenValidity($token)
    {
    	try
    	{
	        $client = XenForo_Helper_Http::getClient('https://graph.facebook.com/me?access_token=' . $token);

	        $response = $client->request('GET');

	        $body = $response->getBody();

	        if (preg_match('#^[{\[]#', $body))
	        {
	            $parts = json_decode($body, true);
	        }
	        else
	        {
	            $parts = XenForo_Application::parseQueryString($body);
	        }

	        if (isset($parts['id']))
	        {
	            return true;
	        }
	        else
	        {
	            return false;
	        }
		}
		catch (Zend_Http_Client_Exception $e)
		{
			return false;
		}        
    }	
}
