<?php

class SocialConnect_Helper_Twitter
{
	/**
	* Gets a request token from Twitter.
	* Will be stored and then used for Authorisation.
	* 
	* @return string
	*/
	public static function getRequestToken()
	{
		$visitor = XenForo_Visitor::getInstance();
		$time = XenForo_Application::$time;
		
		$options = XenForo_Application::get('options');
		
		$consumerKey = $options->socialConnectTwitterConsumerKey;
		$consumerSecret = $options->socialConnectTwitterConsumerSecret;
		
		if (!$consumerKey || !$consumerSecret)
		{
			return false;
		}
		
		$redirect = XenForo_Template_Helper_Core::link('canonical:account/social-connect/callback');
		
		$salt = $consumerKey;
		$nonce = md5($redirect . $visitor['user_id'] . $time . $salt);
		
		$oAuthReq = array(
			'oauth_callback' => $redirect,
			'oauth_consumer_key' => $consumerKey,
			'oauth_nonce' => $nonce,
			'oauth_signature_method' => 'HMAC-SHA1',
			'oauth_timestamp' => $time,
			'oauth_version' => '1.0'			
		);
		
		$baseUri = 'https://api.twitter.com/oauth/request_token';
		$queryString = XenForo_Link::buildQueryString($oAuthReq);
		
		$baseString = 'POST&' . rawurlencode($baseUri) . '&' . rawurlencode($queryString);
		
		$compositeKey = self::_getCompositeKey($consumerSecret);
		
		$oauth_signature = base64_encode(hash_hmac('sha1', $baseString, $compositeKey, true));
		$oAuthReq['oauth_signature'] = $oauth_signature;
		
		$client = XenForo_Helper_Http::getClient($baseUri);
		
		$client->setParameterPost($oAuthReq);
		
		$response = $client->request('POST');
		
		return $response->getBody();
	}
	
	public static function getAccessToken($oAuthToken, $oAuthVerifier)
	{
		$visitor = XenForo_Visitor::getInstance();
		$time = XenForo_Application::$time;
			
		$options = XenForo_Application::get('options');
		
		$consumerKey = $options->socialConnectTwitterConsumerKey;
		$consumerSecret = $options->socialConnectTwitterConsumerSecret;
		
		if (!$consumerKey || !$consumerSecret)
		{
			return false;
		}	
			
		$redirect = XenForo_Template_Helper_Core::link('canonical:account/social-connect/callback');
		
		$salt = $consumerKey;
		$nonce = md5($redirect . $visitor['user_id'] . $time . $salt);
		
		$oAuthReq = array(
			'oauth_callback' => $redirect,
			'oauth_consumer_key' => $consumerKey,
			'oauth_nonce' => $nonce,
			'oauth_signature_method' => 'HMAC-SHA1',
			'oauth_timestamp' => $time,
			'oauth_token' => $oAuthToken,
			'oauth_verifier' => $oAuthVerifier,
			'oauth_version' => '1.0',
		);		
		
		$baseUri = 'https://api.twitter.com/oauth/access_token';
		$queryString = XenForo_Link::buildQueryString($oAuthReq);
		
		$baseString = 'POST&' . rawurlencode($baseUri) . '&' . rawurlencode($queryString);
		
		$compositeKey = self::_getCompositeKey($consumerSecret, $oAuthVerifier);
		
		$oauth_signature = base64_encode(hash_hmac('sha1', $baseString, $compositeKey, true));
		$oAuthReq['oauth_signature'] = $oauth_signature;
		
		$authHeader = "OAuth oauth_consumer_key=" . rawurlencode($oAuthReq['oauth_consumer_key']) . ","
			. "oauth_callback=" . rawurlencode($oAuthReq['oauth_callback']) . ","
		    . "oauth_nonce=" . rawurlencode($oAuthReq['oauth_nonce']) . ","
		    . "oauth_signature_method=" . rawurlencode($oAuthReq['oauth_signature_method']) . ","
		    . "oauth_signature=" . rawurlencode($oAuthReq['oauth_signature']) . ","
		    . "oauth_timestamp=". rawurlencode($oAuthReq['oauth_timestamp']) . ","
		    . "oauth_token=" . rawurlencode($oAuthReq['oauth_token']) . ","
		    . "oauth_verifier=" . rawurlencode($oAuthReq['oauth_verifier']) . ","		    
		    . "oauth_version=" . rawurlencode($oAuthReq['oauth_version']);
		    
		$headers = 'Content-Type: application/x-www-form-urlencoded\r\nAuthorization: ' . $authHeader . '\r\n';
		
		$client = XenForo_Helper_Http::getClient($baseUri);
		
		$client->setHeaders($headers);
		
		$client->setParameterPost($oAuthReq);
		
		$response = $client->request('POST');
		
		return $response->getBody();		
	}
	
	public static function postStatusUpdate($status, $oAuthToken, $oAuthSecret)
	{
		$visitor = XenForo_Visitor::getInstance();
		$time = XenForo_Application::$time;
			
		$options = XenForo_Application::get('options');
		
		$consumerKey = $options->socialConnectTwitterConsumerKey;
		$consumerSecret = $options->socialConnectTwitterConsumerSecret;
		
		if (!$consumerKey || !$consumerSecret)
		{
			return false;
		}
		
		$redirect = XenForo_Template_Helper_Core::link('canonical:account/social-connect');
		
		$salt = $consumerKey;
		$nonce = md5($redirect . $visitor['user_id'] . $time . $salt);
		
		$oAuthReq = array(
			'oauth_consumer_key' => $consumerKey,
			'oauth_nonce' => $nonce,
			'oauth_signature_method' => 'HMAC-SHA1',
			'oauth_timestamp' => $time,
			'oauth_token' => $oAuthToken,
			'oauth_version' => '1.0'
		);
		
		$baseUri = 'https://api.twitter.com/1.1/statuses/update.json';
		$queryString = XenForo_Link::buildQueryString($oAuthReq);
		
		$baseString = 'POST&' . rawurlencode($baseUri) . '&' . rawurlencode($queryString);
		
		$compositeKey = self::_getCompositeKey($consumerSecret, $oAuthSecret);
		
		$oauth_signature = base64_encode(hash_hmac('sha1', $baseString, $compositeKey, true));
		$oAuthReq['oauth_signature'] = $oauth_signature;
		
		$authHeader = "Authorization: OAuth oauth_consumer_key=" .'"' . rawurlencode($oAuthReq['oauth_consumer_key'])
			. '", oauth_nonce="' . rawurlencode($oAuthReq['oauth_nonce'])
			. '", oauth_signature_method="' . rawurlencode($oAuthReq['oauth_signature_method'])
			. '", oauth_signature="' . rawurlencode($oAuthReq['oauth_signature'])
			. '", oauth_timestamp="' . rawurlencode($oAuthReq['oauth_timestamp'])
			. '", oauth_token="' . rawurlencode($oAuthReq['oauth_token'])
			. '", oauth_version="' . rawurlencode($oAuthReq['oauth_version']) . '"';

		$options = array(
			CURLOPT_HTTPHEADER => array($authHeader),
			CURLOPT_HEADER => false,
			CURLOPT_URL => $baseUri,
			CURLOPT_POST => true,
			CURLOPT_POSTFIELDS => array('status' => $status),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_VERBOSE => true,
		    CURLOPT_SSL_VERIFYPEER => false
		);
		
		$feed = curl_init();
		curl_setopt_array($feed, $options);
		$json = curl_exec($feed);
		curl_close($feed);
		
		$twitter_data = json_decode($json);
		
		return $twitter_data;
	}
		
	/**
	* Get the composite key to sign requests
	* 
	* @param string $consumerSecret
	* @param string $requestToken
	* 
	* @return string
	*/
	protected static function _getCompositeKey($consumerSecret, $requestToken = null)
	{
		return rawurlencode($consumerSecret) . '&' . rawurlencode($requestToken);
	}
	
	public static function countTweetLength($status)
	{
		$tweetLength = strlen($status);

		preg_match_all('#\b(?:(?:https?)://|www\.)[-A-Z0-9+&@\#/%=~_|$?!:,.]*[A-Z0-9+&@\#/%=~_|$]#ui', $status, $matches);

		$urlLength = 0;
		$shortLength = 0;
		foreach ($matches[0] AS $url)
		{
			$urlLength += strlen($url);

			if (preg_match('/^(http:)\/\//', $url))
			{
				$shortLength += 20;
			}
			elseif (preg_match('/^(https:)\/\//', $url))
			{
				$shortLength += 21;
			}
			else
			{
				$shortLength += 20;
			}
		}

		$tweetLength = $tweetLength - $urlLength + $shortLength;

		return $tweetLength;
	}	
}