<?php

class SocialConnect_Install
{
	public static function installer()
	{
		if (XenForo_Application::$versionId < 1020033)
		{
			throw new XenForo_Exception('This add-on requires XenForo 1.2.0 Beta 3 or higher.', true);
		}
		
		$db = XenForo_Application::getDb();
		
    	$exists = $db->fetchRow("
			SHOW COLUMNS
			FROM xf_user
			WHERE Field = ?
		", 'social_tokens');
    
    	if (!$exists)
    	{
    		$db->query("
    			ALTER TABLE xf_user ADD social_tokens mediumblob NULL AFTER warning_points
    		");
    	}		
	}
	
	public static function uninstaller()
	{
		$db = XenForo_Application::getDb();
		
		$exists = $db->fetchRow('
			SHOW COLUMNS
			FROM xf_user
			WHERE Field = ?
		', 'social_tokens');
		
		if ($exists)
		{
			$db->query('
				ALTER TABLE xf_user DROP social_tokens
			');
		}
	}
}