<?php

class SocialConnect_Listener
{
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		switch ($hookName)
		{
			case 'navigation_visitor_tab_links2':

				$options = XenForo_Application::get('options');
				
				$params = $template->getParams();				
				$params['addOnEnabled'] = true;
				
				$facebookDisabled = false;
				if (!$options->socialConnectFacebookAppId || !$options->socialConnectFacebookAppSecret)
				{
					$facebookDisabled = true;
				}
				
				$twitterDisabled = false;
				if (!$options->socialConnectTwitterConsumerKey || !$options->socialConnectTwitterConsumerSecret)
				{
					$twitterDisabled = true;
				}
				
				if ($facebookDisabled && $twitterDisabled)
				{
					$params['addOnEnabled'] = false;
				}

				$params += $hookParams;
							
				$contents .= $template->create('social_connect_navigation_visitor_tab', $params);
				break;
				
			case 'account_wrapper_sidebar_settings':
			
				$params = $template->getParams();
				$params += $hookParams;
				
				$contents .= $template->create('social_connect_account_wrapper_sidebar', $params);
				break;
				
			case 'header':
				$visitor = XenForo_Visitor::getInstance();
				$params = $template->getParams();
				$hookParams['tokens'] = unserialize($visitor['social_tokens']);
				$params += $hookParams;
				
				$statusEditor = '/<textarea name="message"[^>]*>.*?<\/textarea>/i';
				
				$editorTemplate = $template->create('social_connect_status_editor', $params)->render();
				
				$contents = preg_replace($statusEditor, $editorTemplate, $contents);
				break;
				
			case 'account_personal_details_status':
				$visitor = XenForo_Visitor::getInstance();
				
				$params = $template->getParams();
				$hookParams['tokens'] = unserialize($visitor['social_tokens']);
				$hookParams['accountEditor'] = true;
				$params += $hookParams;
				
				$statusEditor = '/<textarea name="status"[^>]*>.*?<\/textarea>/i';
				
				$editorTemplate = $template->create('social_connect_status_editor', $params)->render();
				
				$contents = preg_replace($statusEditor, $editorTemplate, $contents);
				break;				
				
			case 'thread_create':
				$visitor = XenForo_Visitor::getInstance();
				
				$params = $template->getParams();
				$hookParams['tokens'] = unserialize($visitor['social_tokens']);
				$hookParams['type'] = 'thread';
				$params += $hookParams;
				
				$pattern = '/<!-- slot: after_editor -->(.*)/';
				$replacement = $template->create('social_connect_service_status', $params) . '$0';
				$contents = preg_replace($pattern, $replacement, $contents);
		}
	}
	
	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
	{
		switch ($templateName)
		{
			case 'account_wrapper':
				$template->preloadTemplate('social_connect_account_wrapper_sidebar');
				break;
				
			case 'social_connect_account_settings':
				$template->preloadTemplate('social_connect_status_editor');
				break;
				
			case 'member_view':
				$template->preloadTemplate('social_connect_status_editor');
				break;
				
			case 'account_personal_details':
				$template->preloadTemplate('social_connect_status_editor');
				break;
				
			case 'thread_create':
				$template->preloadTemplate('social_connect_service_status');
				break;
		}
	}	
	
	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		switch ($templateName)
		{
			case 'member_view':
			
				$visitor = XenForo_Visitor::getInstance();
				
				$params = $template->getParams();
				
				if (isset($visitor['social_tokens']))				
				{
					$params['tokens'] = unserialize($visitor['social_tokens']);
				}
				
				$params['profileEditor'] = true;
				
				$statusEditor = '/<textarea name="message"[^>]*>.*?<\/textarea>/i';
				$editorTemplate = $template->create('social_connect_status_editor', $params)->render();
				
				$content = preg_replace($statusEditor, $editorTemplate, $content);
				
				break;
				
			case 'wf_widget_recent_status':
			
				$visitor = XenForo_Visitor::getInstance();
				
				$params = $template->getParams();
				
				if (isset($visitor['social_tokens']))				
				{
					$params['tokens'] = unserialize($visitor['social_tokens']);
				}
								
				$statusEditor = '/<textarea name="message"[^>]*>.*?<\/textarea>/i';
				$editorTemplate = $template->create('social_connect_status_editor', $params)->render();
				
				$content = preg_replace($statusEditor, $editorTemplate, $content);
				
				break;
				
			case 'EWRblock_StatusUpdates':
			
				$visitor = XenForo_Visitor::getInstance();
				
				$params = $template->getParams();
				
				if (isset($visitor['social_tokens']))				
				{
					$params['tokens'] = unserialize($visitor['social_tokens']);
				}
								
				$statusEditor = '/<textarea[^>]*name="message"[^>]*>.*?<\/textarea>/i';
				$editorTemplate = $template->create('social_connect_status_editor', $params)->render();
				
				$editorTemplate = preg_replace('/name="message"/i', 'name="message" style="width: 100%; margin-bottom: 5px;"', $editorTemplate);
				
				$content = preg_replace($statusEditor, $editorTemplate, $content);
				
				break;
		}
	}
	
	public static function extendControllers($class, array &$extend)
	{
		switch ($class)
		{
			case 'XenForo_ControllerPublic_Account':
			
				$extend[] = 'SocialConnect_ControllerPublic_Account';
				break;
				
			case 'XenForo_ControllerPublic_Forum':
			
				$extend[] = 'SocialConnect_ControllerPublic_Forum';
				break;
				
			case 'XenForo_ControllerPublic_Register':
			
				$extend[] = 'SocialConnect_ControllerPublic_Register';
				break;				
		}
	}
	
	public static function extendDataWriters($class, array &$extend)
	{
		switch ($class)
		{
			case 'XenForo_DataWriter_DiscussionMessage_ProfilePost':
			
				$extend[] = 'SocialConnect_DataWriter_DiscussionMessage_ProfilePost';
				break;
				
			case 'XenForo_DataWriter_Discussion_Thread':
			
				$extend[] = 'SocialConnect_DataWriter_Discussion_Thread';
				break;				
				
			case 'XenForo_DataWriter_User':
			
				$extend[] = 'SocialConnect_DataWriter_User';
				break;
		}
	}	
	
	public static function extendModels($class, array &$extend)
	{
		switch ($class)
		{
			case 'XenForo_Model_Trophy':
			
				$extend[] = 'SocialConnect_Model_Trophy';
				break;
		}
	}	
}