<?php

class SocialConnect_Model_Trophy extends XFCP_SocialConnect_Model_Trophy
{
	public function awardUserTrophy(array $user, $username, array $trophy, $awardDate = null)
	{
		$options = XenForo_Application::get('options');
		
		$facebookDisabled = false;
		if (!$options->socialConnectFacebookAppId || !$options->socialConnectFacebookAppSecret)
		{
			$facebookDisabled = true;
		}
		
		$twitterDisabled = false;
		if (!$options->socialConnectTwitterConsumerKey || !$options->socialConnectTwitterConsumerSecret)
		{
			$twitterDisabled = true;
		}
		
		if ($facebookDisabled && $twitterDisabled)
		{
			return parent::awardUserTrophy($user, $username, $trophy, $awardDate);
		}
				
		$visitor = XenForo_Visitor::getInstance();
		
		if(!isset($visitor['social_tokens']))
		{
			return parent::awardUserTrophy($user, $username, $trophy, $awardDate);
		}
		
		$tokens = unserialize($visitor['social_tokens']);
		
		if (isset($tokens['twitter']) && $tokens['twitter']['trophy'] && !$twitterDisabled)
		{
			$trophyTitle = new XenForo_Phrase('trophy_' . $trophy['trophy_id'] . '_title');
	
			$trophiesUrl = XenForo_Template_Helper_Core::link('canonical:members/trophies', $user);
			
			$tweetPhrase = new XenForo_Phrase('social_connect_awarded_x_trophy_at_y', array('trophy' => $trophyTitle->__toString(), 'board' => XenForo_Application::get('options')->boardTitle));
			
			$tweetLen = strlen($tweetPhrase);
			
			if (($tweetLen + 20) <= 139)
			{
				$tweetPhrase = $tweetPhrase . ' ' . $trophiesUrl;
			}
			else
			{		
				$tweetPhrase = XenForo_Helper_String::wholeWordTrim($tweetPhrase, 115);
				$tweetPhrase = $tweetPhrase . ' ' . $trophiesUrl;
			}
			
			$tweet = SocialConnect_Helper_Twitter::postStatusUpdate($tweetPhrase, $tokens['twitter']['oauth_token'], $tokens['twitter']['oauth_token_secret']);
		}
		
		if (isset($tokens['facebook']) && $tokens['facebook']['trophy'] && !$facebookDisabled)
		{
			$trophyTitle = new XenForo_Phrase('trophy_' . $trophy['trophy_id'] . '_title');
	
			$trophiesUrl = XenForo_Template_Helper_Core::link('canonical:members/trophies', $user);
			
			$postPhrase = new XenForo_Phrase('social_connect_awarded_x_trophy_at_y', array('trophy' => $trophyTitle->__toString(), 'board' => XenForo_Application::get('options')->boardTitle));
			
			$postPhrase = $postPhrase . ' ' . $trophiesUrl;
			
			$statusUpdate = SocialConnect_Helper_Facebook::postStatusUpdate($postPhrase, $tokens['facebook']['access_token']);
		}		

		return parent::awardUserTrophy($user, $username, $trophy, $awardDate);
	}
}
