<?php

class SocialConnect_Option_FacebookAdminToken
{
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$options = XenForo_Application::get('options');
		
		// Facebook requires a specially encoded URL keep it simple and force non friendly URL. Doesn't matter, no one sees it.
		$prefix = $options->boardUrl . '/index.php?';
		$suffix = urlencode('account/social-connect/admin-callback');
		$redirectUri = $prefix . $suffix;
		
		$fbAuthoriseUri = SocialConnect_Helper_Facebook::getFacebookLogin($redirectUri);
		$params = array(
			'fbAuthoriseUri' => $fbAuthoriseUri
		);		
		
		return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
			'', //'social_connect_option_template_fb_admin_token',
			$view, $fieldPrefix, $preparedOption, $canEdit, $params
		);
	}
}