<?php

class StickyFirstPost_ControllerPublic_Forum extends XFCP_StickyFirstPost_ControllerPublic_Forum
{
	public function actionCreateThread()
	{
		$response = parent::actionCreateThread();
		
		$options = XenForo_Application::getOptions();
        $nodeList = $options->StickyFirstPost_nodes;
		
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);

		$forumModel = $this->_getForumModel();
		
		$response->params['canStickUnstickPost'] = $forumModel->canStickUnstickPostInForum($forum);
		
		if(in_array($forum['node_id'], $nodeList))
			$response->params['thread']['post_sticky'] = 1;
		return $response;	
	}
	
	public function actionAddThread()
    {
        $response = parent::actionAddThread();
        $threadId = XenForo_Application::get('last_thread');
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		
        $input_ps = $this->_input->filterSingle('post_sticky', XenForo_Input::UINT);
		if ($input_ps)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
			$dw->setExistingData($threadId);
			$dw->set('post_sticky',$input_ps,'xf_thread');
			$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forum);
			$dw->save();
		}
        return $response;
    }
}