<?php

class StickyFirstPost_ControllerPublic_Thread extends XFCP_StickyFirstPost_ControllerPublic_Thread
{
	/**
	 * Stick / Unstick first post in a thread.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionQuickUpdate()
	{
		parent::actionQuickUpdate();
		
		$this->_assertPostOnly();
		$this->_assertRegistrationRequired();		
		
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);

		$threadModel = $this->_getThreadModel();
		
		$input = $this->_input->filter(array(
		'post_sticky' => XenForo_Input::UINT,
		));
		
		
		$set['post_sticky'] = $this->_input->filterSingle('post_sticky', XenForo_Input::UINT);
		
		$dwInput = array();
		
		if (isset($set['post_sticky']) && $threadModel->canStickUnstickPost($thread, $forum))
		{
			$dwInput['post_sticky'] = $input['post_sticky'];
		}
		
		if ($dwInput)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
			$dw->setExistingData($threadId);
			$dw->set('post_sticky',$dwInput['post_sticky'],'xf_thread');
			$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forum);
			$dw->save();
			
			XenForo_Model_Log::logModeratorAction('thread', $thread, ($dwInput['post_sticky'] ? 'post_stick' : 'post_unstick'));			
		}
		
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('threads', $thread)
		);
	}
	
	public function actionIndex()
	{
		$response = parent::actionIndex();
		
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		
		$threadModel = $this->_getThreadModel();
		$response->params['canStickUnstickPost'] = $threadModel->canStickUnstickPost($thread, $forum);
		return $response;
	}
	
	public function actionSave()
	{
		parent::actionSave();
		
		$this->_assertPostOnly();
		$this->_assertRegistrationRequired();
		
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		
		$this->_assertCanEditThread($thread, $forum);
		
		$dwInput = $this->_input->filter(array(
		'post_sticky' => XenForo_Input::UINT
		));
		
		$threadModel = $this->_getThreadModel();
		
		if (!$threadModel->canStickUnstickPost($thread, $forum))
		{
			unset($dwInput['post_sticky']);
		}
		
		if ($dwInput)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
			$dw->setExistingData($threadId);
			$dw->set('post_sticky',$dwInput['post_sticky'],'xf_thread');
			$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forum);
			$dw->save();
			
			XenForo_Model_Log::logModeratorAction('thread', $thread, ($dwInput['post_sticky'] ? 'post_stick' : 'post_unstick'));
			$thread = $dw->getMergedData();			
		}		
		
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('threads', $thread)
		);
	}
	
	public function actionEdit()
	{
		$response = parent::actionEdit();
		
		$this->_assertRegistrationRequired();
		
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		
		$this->_assertCanEditThread($thread, $forum);
		
		$threadModel = $this->_getThreadModel();
		
		$response->params['canStickUnstickPost'] = $threadModel->canStickUnstickPost($thread, $forum);
		
		return $response;
	}
}