<?php

/**
* Data writer for threads.
*/
class StickyFirstPost_DataWriter_Discussion_Thread extends XFCP_StickyFirstPost_DataWriter_Discussion_Thread
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		$fields = parent::_getFields();
		$fields['xf_thread']['post_sticky'] = array('type' => self::TYPE_BOOLEAN, 'default' => 0);
		return $fields;
	}
	
	protected function _discussionPostSave(array $messages)
    {
        parent::_discussionPostSave($messages);
        $threadId = $this->get('thread_id');
        XenForo_Application::set('last_thread',$threadId);
    }
	
	/**
	 * @return XenForo_Model_Forum
	 */
	protected function _getForumModel()
	{
		return $this->getModelFromCache('XenForo_Model_Forum');
	}
}