<?php

class StickyFirstPost_Listener
{
	public static function renderNodes(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        $preparedOption['formatParams'] = self::getNodeOptions($preparedOption['option_value']);

        return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal('StickyFirstPost_nodes', $view, $fieldPrefix, $preparedOption, $canEdit);
    }
	
	public static function getNodeOptions($selectedForum, $includeRoot = false)
    {
        $nodeModel = XenForo_Model_DataRegistry::create('XenForo_Model_Node');
		
        $options = array();
		
        foreach($nodeModel->getAllNodes() AS $nodeId=>$node)
        {
            $node['depth'] += (($includeRoot && $nodeId) ? 1 : 0);
			
            $options[$nodeId] = array(
			'value'       =>$nodeId,
			'label'       =>$node['title'],
			'selected'    =>in_array($nodeId, $selectedForum),
			'depth'       =>$node['depth'],
			'node_type_id'=>$node['node_type_id']
            );
        }
		
        return $options;
    }
	
	public static function template_hook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{	
		switch ($hookName) {
			case 'thread_create_fields_extra':
				$ourTemplate = $template->create('SFP_thread_create', $template->getParams());
				$rendered = $ourTemplate->render();
				$contents = $contents.$rendered;
				break;
			case 'page_container_js_body':
				$ourTemplate = $template->create('SFP_js_first_post', $template->getParams());
				$rendered = $ourTemplate->render();
				$contents = $contents.$rendered;
				break;
			case 'xenforo_css_extra':
				$ourTemplate = $template->create('SFP.css', $template->getParams());
				$rendered = $ourTemplate->render();
				$contents = $contents.$rendered;
				break;
			case 'thread_list_stickies':
				if(!XenForo_Application::get('options')->StickyFirstPost_enable_TMS){
					//Adding Icon to thread list
					$threads = $template->getParam('stickyThreads');
					$exclude = 'myid_' . uniqid(); //Let's create an exclusion for the regex (needs to be deleted at the end)			
					$ourTemplate = $template->create('SFP_sticky_post_icon');
					
					foreach ($threads as $thread)
					{
						$rendered = $exclude;
						if($thread['post_sticky'] && XenForo_Application::get('options')->StickyFirstPost_show_fsp_icon)
							$rendered = $ourTemplate->render();
						$replace = $exclude . '$0' .$rendered;					
						$find = '/(?<!' . $exclude . ')(<h3 class="title.*?<\/h3>)/si';
						
						$contents = preg_replace($find,$replace,$contents, 1);
					}
					
					$contents = str_replace($exclude, '', $contents); //Clean regex exclusion from template
					
					//Adding class to thread list
					foreach ($threads as $thread)
					{
						$rendered = $exclude;
						if($thread['post_sticky'])
							$rendered = ' post_sticky';
						$replace = $exclude . '$0' .$rendered;					
						$find = '/(?<!' . $exclude . ')(class="discussionListItem)/si';
						
						$contents = preg_replace($find,$replace,$contents, 1);
					}
					
					$contents = str_replace($exclude, '', $contents); //Clean regex exclusion from template
				}
				break;
			case 'thread_list_threads':
				if(!XenForo_Application::get('options')->StickyFirstPost_enable_TMS){				
					//Adding Icon to thread list
					$threads = $template->getParam('threads');
					$exclude = 'myid_' . uniqid(); //Let's create an exclusion for the regex (needs to be deleted at the end)			
					$ourTemplate = $template->create('SFP_sticky_post_icon');
					
					foreach ($threads as $thread)
					{
						$rendered = $exclude;
						if($thread['post_sticky'] && XenForo_Application::get('options')->StickyFirstPost_show_fsp_icon)
							$rendered = $ourTemplate->render();	
						$replace = $exclude . '$0' .$rendered;					
						$find = '/(?<!' . $exclude . ')(<h3 class="title.*?<\/h3>)/si';
						
						$contents = preg_replace($find,$replace,$contents, 1);
					}
					
					$contents = str_replace($exclude, '', $contents); //Clean regex exclusion from template
					
					//Adding class to thread list
					foreach ($threads as $thread)
					{
						$rendered = $exclude;
						if($thread['post_sticky'])
							$rendered = ' post_sticky';
						$replace = $exclude . '$0' .$rendered;					
						$find = '/(?<!' . $exclude . ')(class="discussionListItem)/si';
						
						$contents = preg_replace($find,$replace,$contents, 1);
					}
					
					$contents = str_replace($exclude, '', $contents); //Clean regex exclusion from template
				}
				break;
			
		}
	}
	
	public static function template_create($templateName, array &$params, XenForo_Template_Abstract $template)
	{
		switch ($templateName) {
			case 'thread_create':
				$template->preloadTemplate('SFP_thread_create');
				break;
			case 'message':
				$template->preloadTemplate('SFP_js_first_post');
				break;
			case 'xenforo.css':
				$template->preloadTemplate('SFP.css');
				$template->preloadTemplate('SFP_manual_layout.css');
				break;
			case 'thread_list':
				$template->preloadTemplate('SFP_sticky_post_icon');
				break;
			case 'thread_view':
				$template->preloadTemplate('SFP_thread_view');
				$template->preloadTemplate('SFP_message_classes');
				break;
			case 'forum_view':
				$template->preloadTemplate('SFP_inline_mod_controls_thread');
				break;
			case 'thread_list_item_edit':
				$template->preloadTemplate('SFP_thread_list_item_edit');		
				break;
			case 'thread_edit':
				$template->preloadTemplate('SFP_thread_create');		
				break;
		}
	}
	
	public static function loadControllers($class, array &$extend)
    {
        if ($class == 'XenForo_ControllerPublic_Forum')
        {
            $extend[] = 'StickyFirstPost_ControllerPublic_Forum';
        }
		
		if ($class == 'XenForo_ControllerPublic_Thread')
        {
            $extend[] = 'StickyFirstPost_ControllerPublic_Thread';
        }
		
		if ($class == 'XenForo_ControllerPublic_InlineMod_Thread')
        {
            $extend[] = 'StickyFirstPost_ControllerPublic_InlineMod_Thread';
        }
    }
	
	public static function loadModels($class, array &$extend)
	{
		if ($class == 'XenForo_Model_Forum')
		{ 
			$extend[] = 'StickyFirstPost_Model_Forum';
		}
		
		if ($class == 'XenForo_Model_Thread')
        {
            $extend[] = 'StickyFirstPost_Model_Thread';
        }
		
		if ($class == 'XenForo_Model_InlineMod_Thread')
        {
            $extend[] = 'StickyFirstPost_Model_InlineMod_Thread';
        }
		
		if ($class == 'XenForo_Model_Post')
		{ 
			$extend[] = 'StickyFirstPost_Model_Post';
		}
	}
	
	public static function loadDataWriters($class, array &$extend)
	{
		if ($class == 'XenForo_DataWriter_Discussion_Thread')
		{ 
			$extend[] = 'StickyFirstPost_DataWriter_Discussion_Thread';
		}
	}
	
	public static function templatePostRender ($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		if(!XenForo_Application::get('options')->StickyFirstPost_enable_TMS){
			if($templateName == 'thread_view'){
				$app = $template->create('SFP_thread_view',$template->getParams());
				$find = '/(<li>.*?<label>.*?name="sticky".*?<\/label>.*?<\/li>)/si';
				$replace = '$1'.$app;
				$content = preg_replace($find,$replace,$content);
			
				$app = $template->create('SFP_message_classes',$template->getParams());
				$find = '/(<li id=".*" class="message )/ui';
				$replace = '$1'.$app;
				$content = preg_replace($find,$replace,$content,1);
			
				$find = '/(<dl class="pairsInline) (userField_)/ui';
				$replace = '$1 customFields $2';
				$content = preg_replace($find,$replace,$content);
			}

			if($templateName == 'forum_view'){
				$app = $template->create('SFP_inline_mod_controls_thread',$template->getParams());
				$find = '/(<optgroup label="Moderation Actions">)/ui';
				$replace = '$1'.$app;
				$content = preg_replace($find,$replace,$content,1);
			}
			
			if($templateName == 'thread_list_item_edit'){
				$app = $template->create('SFP_thread_list_item_edit',$template->getParams());
				$find = '/(<ul class="optionsEdit editBlock">.*)(<\/ul>)/sui';
				$replace = '$1'.$app."\n".'$2';
				$content = preg_replace($find,$replace,$content);
			}
			
			if($templateName == 'thread_edit'){
				$app = $template->create('SFP_thread_create',$template->getParams());
				$find = '/(<dl class="ctrlUnit submitUnit">)/sui';
				$replace = $app.'$1';
				$content = preg_replace($find,$replace,$content);
			}
		}
	}
}

?>