<?php

class StickyFirstPost_Model_Forum extends XFCP_StickyFirstPost_Model_Forum
{
	/**
	 * Determines if the first post can be stuck or unstuck in the specified forum
	 * with the given permissions.
		*
	 * @param array $forum
	 * @param string $errorPhraseKey
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
		*
	 * @return boolean
	 */
	public function canStickUnstickPostInForum(array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		$this->standardizeViewingUserReferenceForNode($forum['node_id'], $viewingUser, $nodePermissions);
		
		if (!$viewingUser['user_id'])
		{
			return false;
		}
		
		return XenForo_Permission::hasContentPermission($nodePermissions, 'stickUnstickPost');
	}
}