<?php

class StickyFirstPost_Model_InlineMod_Thread extends XFCP_StickyFirstPost_Model_InlineMod_Thread
{
	public function canStickUnstickPosts(array $threadIds, &$errorKey = '', array $viewingUser = null)
	{
		list($threads, $forums) = $this->getThreadsAndParentData($threadIds, $viewingUser);
		return $this->canStickUnstickPostsData($threads, $forums, $errorKey, $viewingUser);
	}

	public function canStickUnstickPostsData(array $threads, array $forums, &$errorKey = '', array $viewingUser = null)
	{
		return $this->_checkPermissionOnThreads('canStickUnstickPost', $threads, $forums, $errorKey, $viewingUser);
	}

	public function stickPosts(array $threadIds, array $options = array(), &$errorKey = '', array $viewingUser = null)
	{
		list($threads, $forums) = $this->getThreadsAndParentData($threadIds, $viewingUser);

		if (empty($options['skipPermissions']) && !$this->canStickUnstickPostsData($threads, $forums, $errorKey, $viewingUser))
		{
			return false;
		}

		$this->_updateThreadsBulk($threads, $forums, array('post_sticky' => 1), 'post_stick');

		return true;
	}

	public function unstickPosts(array $threadIds, array $options = array(), &$errorKey = '', array $viewingUser = null)
	{
		list($threads, $forums) = $this->getThreadsAndParentData($threadIds, $viewingUser);

		if (empty($options['skipPermissions']) && !$this->canStickUnstickPostsData($threads, $forums, $errorKey, $viewingUser))
		{
			return false;
		}

		$this->_updateThreadsBulk($threads, $forums, array('post_sticky' => 0), 'post_unstick');

		return true;
	}
}