<?php

class StickyFirstPost_Model_Post extends XFCP_StickyFirstPost_Model_Post
{
	/**
	 * Returns all posts for a specified thread. Fetch options may limit
	 * posts returned.
		*
	 * @param integer $threadId
	 * @param array $fetchOptions Collection of options that relate to fetching
		*
	 * @return array
	 */
    public function getPostsInThread($threadId, array $fetchOptions = array())
	{
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
		$stateLimit = $this->prepareStateLimitFromConditions($fetchOptions, 'post');
		$joinOptions = $this->preparePostJoinOptions($fetchOptions);
		
		//Prepend join thread table if post_sticky = 1
		$joinOptions['joinTables'] = '
					LEFT JOIN xf_thread AS thread ON
						(thread.thread_id = post.thread_id AND thread.post_sticky = 1)'.$joinOptions['joinTables'];
		
		//Extended the WHERE clause to include our first post
		return $this->fetchAllKeyed('
			SELECT post.*
				' . $joinOptions['selectFields'] . '
			FROM xf_post AS post
				' . $joinOptions['joinTables'] . '
			WHERE post.thread_id = ?
				AND (((' . $stateLimit . ')
				' . $this->addPositionLimit('post', $limitOptions['limit'], $limitOptions['offset']) . ') OR (post.post_id = thread.first_post_id AND thread.post_sticky))
			ORDER BY post.position ASC, post.post_date ASC
			', 'post_id', $threadId);
	}
}