<?php

class StickyFirstPost_Model_Thread extends XFCP_StickyFirstPost_Model_Thread
{
	/**
	 * Determines if the first post can be stuck/unstuck with the given permissions.
	 * This does not check viewing permissions.
		*
	 * @param array $thread
	 * @param array $forum
	 * @param string $errorPhraseKey
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
		*
	 * @return boolean
	 */
	public function canStickUnstickPost(array $thread, array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		$this->standardizeViewingUserReferenceForNode($thread['node_id'], $viewingUser, $nodePermissions);
		return ($viewingUser['user_id'] && XenForo_Permission::hasContentPermission($nodePermissions, 'stickUnstickPost'));
	}
	
	public function addInlineModOptionToThread(array &$thread, array $forum, array $nodePermissions = null, array $viewingUser = null)
	{
		$response = parent:: addInlineModOptionToThread($thread, $forum, $nodePermissions, $viewingUser);	
		
		$this->standardizeViewingUserReferenceForNode($thread['node_id'], $viewingUser, $nodePermissions);
		
		$canInlineMod = ($viewingUser['user_id'] && (
		XenForo_Permission::hasContentPermission($nodePermissions, 'deleteAnyThread')
		|| XenForo_Permission::hasContentPermission($nodePermissions, 'undelete')
		|| XenForo_Permission::hasContentPermission($nodePermissions, 'approveUnapprove')
		|| XenForo_Permission::hasContentPermission($nodePermissions, 'lockUnlockThread')
		|| XenForo_Permission::hasContentPermission($nodePermissions, 'stickUnstickThread')
		|| XenForo_Permission::hasContentPermission($nodePermissions, 'manageAnyThread')
		));
		
		if ($canInlineMod)
		{
			if ($this->canStickUnstickPost($thread, $forum, $null, $nodePermissions, $viewingUser))
			{
				$response['stickPosts'] = true;
				$response['unstickPosts'] = true;
			}
		}
		
		$thread['canInlineMod'] = (count($response) > 0);
		
		return $response;
	}
}