<?php

/**
 * Alert handler for user name changes.
 *
 * @package UserEss
 */
class UserEss_AlertHandler_UNC extends XenForo_AlertHandler_Abstract
{
	/**
	 * @var XenForo_Model_User
	 */
	protected $_userModel = null;
	
	/**
	 * Fetches the content required by alerts.
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_Alert $model Alert model invoking this
	 * @param integer $userId User ID the alerts are for
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		return $this->_getUNCModel()->getUNCByIds($contentIds);
	}
	
	public function canViewAlert(array $alert, $content, array $viewingUser)
	{
		if ($viewingUser['user_id'] != $alert['alerted_user_id'])
			return false;
		
		if ($viewingUser['user_id'] != $content['user_id'] && !($viewingUser['is_moderator'] || $viewingUser['is_admin']))
			return false;
		
		return true;
	}
	
	/**
	 * @return UserEss_Model_UNC
	 */
	protected function _getUNCModel()
	{
		if (!isset($this->_uncModel))
		{
			$this->_uncModel = XenForo_Model::create('UserEss_Model_UNC');
		}
		
		return $this->_uncModel;
	}
}